/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.IDN;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.DomainValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DomainValidatorTest {
    private DomainValidator validator;

    private static void closeQuietly(Closeable in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static long download(File file, String tldUrl, long timestamp) throws IOException {
        long modTime;
        int hour = 3600000;
        if (file.canRead()) {
            modTime = file.lastModified();
            if (modTime > System.currentTimeMillis() - 3600000L) {
                System.out.println("Skipping download - found recent " + file);
                return modTime;
            }
        } else {
            modTime = 0L;
        }
        HttpURLConnection hc = (HttpURLConnection)new URL(tldUrl).openConnection();
        if (modTime > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            String since = sdf.format(new Date(modTime));
            hc.addRequestProperty("If-Modified-Since", since);
            System.out.println("Found " + file + " with date " + since);
        }
        if (hc.getResponseCode() == 304) {
            System.out.println("Already have most recent " + tldUrl);
        } else {
            System.out.println("Downloading " + tldUrl);
            try (InputStream is = hc.getInputStream();){
                Files.copy(is, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            System.out.println("Done");
        }
        return file.lastModified();
    }

    private static Map<String, String[]> getHtmlInfo(File f) throws IOException {
        HashMap<String, String[]> info = new HashMap<String, String[]>();
        Pattern domain = Pattern.compile(".*<a href=\"/domains/root/db/([^.]+)\\.html");
        Pattern type = Pattern.compile("\\s+<td>([^<]+)</td>");
        Pattern comment = Pattern.compile("\\s+<td>([^<]+)</td>");
        try (BufferedReader br = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = domain.matcher(line);
                if (!m.lookingAt()) continue;
                String dom = m.group(1);
                String typ = "??";
                String com = "??";
                line = br.readLine();
                while (line.matches("^\\s*$")) {
                    line = br.readLine();
                }
                Matcher t = type.matcher(line);
                if (t.lookingAt()) {
                    typ = t.group(1);
                    line = br.readLine();
                    if (line.matches("\\s+<!--.*")) {
                        while (!line.matches(".*-->.*")) {
                            line = br.readLine();
                        }
                        line = br.readLine();
                    }
                    while (!line.matches(".*</td>.*")) {
                        line = line + " " + br.readLine();
                    }
                    Matcher n = comment.matcher(line);
                    if (n.lookingAt()) {
                        com = n.group(1);
                    }
                    if (com.contains("Not assigned") || com.contains("Retired") || typ.equals("test")) continue;
                    info.put(dom.toLowerCase(Locale.ENGLISH), new String[]{typ, com});
                    continue;
                }
                System.err.println("Unexpected type: " + line);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInIanaList(String arrayName, Set<String> ianaTlds) throws Exception {
        Field f = DomainValidator.class.getDeclaredField(arrayName);
        boolean isPrivate = Modifier.isPrivate(f.getModifiers());
        if (isPrivate) {
            f.setAccessible(true);
        }
        String[] array = (String[])f.get(null);
        try {
            boolean bl = DomainValidatorTest.isInIanaList(arrayName, array, ianaTlds);
            return bl;
        }
        finally {
            if (isPrivate) {
                f.setAccessible(false);
            }
        }
    }

    private static boolean isInIanaList(String name, String[] array, Set<String> ianaTlds) {
        for (String element : array) {
            if (ianaTlds.contains(element)) continue;
            System.out.println(name + " contains unexpected value: " + element);
            return false;
        }
        return true;
    }

    private static boolean isLowerCase(String string) {
        return string.equals(string.toLowerCase(Locale.ENGLISH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNotInRootZone(String domain) {
        block6: {
            tldUrl = "https://www.iana.org/domains/root/db/" + domain + ".html";
            rootCheck = new File("target", "tld_" + domain + ".html");
            in = null;
            try {
                DomainValidatorTest.download(rootCheck, tldUrl, 0L);
                in = new BufferedReader(new FileReader(rootCheck));
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.contains("This domain is not present in the root zone at this time.")) continue;
                    var5_6 = true;
                    break block6;
                }
                ** GOTO lbl-1000
            }
            catch (IOException var4_5) {
                DomainValidatorTest.closeQuietly(in);
                return false;
                catch (Throwable var6_7) {
                    DomainValidatorTest.closeQuietly(in);
                    throw var6_7;
                }
            }
        }
        DomainValidatorTest.closeQuietly(in);
        return var5_6;
lbl-1000:
        // 1 sources

        {
            in.close();
        }
        DomainValidatorTest.closeQuietly(in);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSortedLowerCase(String arrayName) throws Exception {
        Field f = DomainValidator.class.getDeclaredField(arrayName);
        boolean isPrivate = Modifier.isPrivate(f.getModifiers());
        if (isPrivate) {
            f.setAccessible(true);
        }
        String[] array = (String[])f.get(null);
        try {
            boolean bl = DomainValidatorTest.isSortedLowerCase(arrayName, array);
            return bl;
        }
        finally {
            if (isPrivate) {
                f.setAccessible(false);
            }
        }
    }

    private static boolean isSortedLowerCase(String name, String[] array) {
        boolean sorted = true;
        boolean strictlySorted = true;
        int length = array.length;
        boolean lowerCase = DomainValidatorTest.isLowerCase(array[length - 1]);
        for (int i = 0; i < length - 1; ++i) {
            String entry = array[i];
            String nextEntry = array[i + 1];
            int cmp = entry.compareTo(nextEntry);
            if (cmp > 0) {
                System.out.println("Out of order entry: " + entry + " < " + nextEntry + " in " + name);
                sorted = false;
            } else if (cmp == 0) {
                strictlySorted = false;
                System.out.println("Duplicated entry: " + entry + " in " + name);
            }
            if (DomainValidatorTest.isLowerCase(entry)) continue;
            System.out.println("Non lowerCase entry: " + entry + " in " + name);
            lowerCase = false;
        }
        return sorted && strictlySorted && lowerCase;
    }

    public static void main(String[] a) throws Exception {
        boolean ok = true;
        for (String list : new String[]{"INFRASTRUCTURE_TLDS", "COUNTRY_CODE_TLDS", "GENERIC_TLDS", "LOCAL_TLDS"}) {
            ok &= DomainValidatorTest.isSortedLowerCase(list);
        }
        if (!ok) {
            System.out.println("Fix arrays before retrying; cannot continue");
            return;
        }
        HashSet<String> ianaTlds = new HashSet<String>();
        DomainValidator dv = DomainValidator.getInstance();
        File txtFile = new File("target/tlds-alpha-by-domain.txt");
        long timestamp = DomainValidatorTest.download(txtFile, "https://data.iana.org/TLD/tlds-alpha-by-domain.txt", 0L);
        File htmlFile = new File("target/tlds-alpha-by-domain.html");
        DomainValidatorTest.download(htmlFile, "https://www.iana.org/domains/root/db", timestamp);
        BufferedReader br = new BufferedReader(new FileReader(txtFile));
        String line = br.readLine();
        if (!line.startsWith("# Version ")) {
            br.close();
            throw new IOException("File does not have expected Version header");
        }
        String header = line.substring(2);
        boolean generateUnicodeTlds = false;
        Map<String, String[]> htmlInfo = DomainValidatorTest.getHtmlInfo(htmlFile);
        TreeMap<String, String> missingTLD = new TreeMap<String, String>();
        TreeMap<String, String> missingCC = new TreeMap<String, String>();
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            String asciiTld = line.toLowerCase(Locale.ENGLISH);
            String unicodeTld = line.startsWith("XN--") ? IDN.toUnicode(line) : asciiTld;
            if (!dv.isValidTld(asciiTld)) {
                String[] info = htmlInfo.get(asciiTld);
                if (info != null) {
                    String type = info[0];
                    String comment = info[1];
                    if ("country-code".equals(type)) {
                        missingCC.put(asciiTld, unicodeTld + " " + comment);
                    } else {
                        missingTLD.put(asciiTld, unicodeTld + " " + comment);
                    }
                } else {
                    System.err.println("Expected to find HTML info for " + asciiTld);
                }
            }
            ianaTlds.add(asciiTld);
        }
        br.close();
        int errorsDetected = 0;
        for (String key : new TreeMap<String, String[]>(htmlInfo).keySet()) {
            if (ianaTlds.contains(key)) continue;
            if (DomainValidatorTest.isNotInRootZone(key)) {
                System.out.println("INFO: HTML entry not yet in root zone: " + key);
                continue;
            }
            ++errorsDetected;
            System.err.println("WARN: Expected to find text entry for html: " + key);
        }
        if (!missingTLD.isEmpty()) {
            ++errorsDetected;
            DomainValidatorTest.printMap(header, missingTLD, "GENERIC_TLDS");
        }
        if (!missingCC.isEmpty()) {
            ++errorsDetected;
            DomainValidatorTest.printMap(header, missingCC, "COUNTRY_CODE_TLDS");
        }
        if (!DomainValidatorTest.isInIanaList("INFRASTRUCTURE_TLDS", ianaTlds)) {
            ++errorsDetected;
        }
        if (!DomainValidatorTest.isInIanaList("COUNTRY_CODE_TLDS", ianaTlds)) {
            ++errorsDetected;
        }
        if (!DomainValidatorTest.isInIanaList("GENERIC_TLDS", ianaTlds)) {
            ++errorsDetected;
        }
        System.out.println("Finished checks");
        if (errorsDetected > 0) {
            throw new RuntimeException("Errors detected: " + errorsDetected);
        }
    }

    private static void printMap(String header, Map<String, String> map, String string) {
        System.out.println("Entries missing from " + string + " List\n");
        if (header != null) {
            System.out.println("        // Taken from " + header);
        }
        for (Map.Entry<String, String> me : map.entrySet()) {
            System.out.println("        \"" + me.getKey() + "\", // " + me.getValue());
        }
        System.out.println("\nDone");
    }

    @BeforeEach
    public void setUp() {
        this.validator = DomainValidator.getInstance();
    }

    @Test
    public void tesLocalTldsSortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("LOCAL_TLDS");
        Assertions.assertTrue((boolean)sorted);
    }

    @Test
    void testAllowLocal() {
        DomainValidator noLocal = DomainValidator.getInstance((boolean)false);
        DomainValidator allowLocal = DomainValidator.getInstance((boolean)true);
        Assertions.assertEquals((Object)noLocal, (Object)this.validator);
        Assertions.assertFalse((boolean)noLocal.isValid("localhost.localdomain"), (String)"localhost.localdomain should validate");
        Assertions.assertFalse((boolean)noLocal.isValid("localhost"), (String)"localhost should validate");
        Assertions.assertTrue((boolean)allowLocal.isValid("localhost.localdomain"), (String)"localhost.localdomain should validate");
        Assertions.assertTrue((boolean)allowLocal.isValid("localhost"), (String)"localhost should validate");
        Assertions.assertTrue((boolean)allowLocal.isValid("hostname"), (String)"hostname should validate");
        Assertions.assertTrue((boolean)allowLocal.isValid("machinename"), (String)"machinename should validate");
        Assertions.assertTrue((boolean)allowLocal.isValid("apache.org"), (String)"apache.org should validate");
        Assertions.assertFalse((boolean)allowLocal.isValid(" apache.org "), (String)"domain name with spaces shouldn't validate");
    }

    @Test
    void testCountryCodeTldsSortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("COUNTRY_CODE_TLDS");
        Assertions.assertTrue((boolean)sorted);
    }

    @Test
    void testDomainNoDots() {
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a"), (String)"a (alpha) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("9"), (String)"9 (alphanum) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("c-z"), (String)"c-z (alpha - alpha) should validate");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("c-"), (String)"c- (alpha -) should fail");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("-c"), (String)"-c (- alpha) should fail");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("-"), (String)"- (-) should fail");
    }

    @Test
    void testEnumIsPublic() {
        Assertions.assertTrue((boolean)Modifier.isPublic(DomainValidator.ArrayType.class.getModifiers()));
    }

    @Test
    void testGenericTldsSortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("GENERIC_TLDS");
        Assertions.assertTrue((boolean)sorted);
    }

    @Test
    void testGetArray() {
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_MINUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_PLUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_MINUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_PLUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_MINUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_PLUS));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.COUNTRY_CODE_RO));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.GENERIC_RO));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.INFRASTRUCTURE_RO));
        Assertions.assertNotNull((Object)DomainValidator.getTLDEntries((DomainValidator.ArrayType)DomainValidator.ArrayType.LOCAL_RO));
    }

    @Test
    void testIDN() {
        Assertions.assertTrue((boolean)this.validator.isValid("www.xn--bcher-kva.ch"), (String)"b\u00fccher.ch in IDN should validate");
    }

    @Test
    void testIDNJava6OrLater() {
        Assertions.assertTrue((boolean)this.validator.isValid("www.b\u00fccher.ch"), (String)"b\u00fccher.ch should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("xn--d1abbgf6aiiy.xn--p1ai"), (String)"xn--d1abbgf6aiiy.xn--p1ai should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444"), (String)"\u043f\u0440\u0435\u0437\u0438\u0434\u0435\u043d\u0442.\u0440\u0444 should validate");
        Assertions.assertFalse((boolean)this.validator.isValid("www.\ufffd.ch"), (String)"www.\ufffd.ch FFFD should fail");
    }

    @Test
    void testInfrastructureTldsSortedAndLowerCase() throws Exception {
        boolean sorted = DomainValidatorTest.isSortedLowerCase("INFRASTRUCTURE_TLDS");
        Assertions.assertTrue((boolean)sorted);
    }

    @Test
    void testInvalidDomains() {
        Assertions.assertFalse((boolean)this.validator.isValid(".org"), (String)"bare TLD .org shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid(" apache.org "), (String)"domain name with spaces shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("apa che.org"), (String)"domain name containing spaces shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("-testdomain.name"), (String)"domain name starting with dash shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("testdomain-.name"), (String)"domain name ending with dash shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("---c.com"), (String)"domain name starting with multiple dashes shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("c--.com"), (String)"domain name ending with multiple dashes shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("apache.rog"), (String)"domain name with invalid TLD shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid("http://www.apache.org"), (String)"URL shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid(" "), (String)"Empty string shouldn't validate as domain name");
        Assertions.assertFalse((boolean)this.validator.isValid(null), (String)"Null shouldn't validate as domain name");
    }

    @Test
    void testIsIDNtoASCIIBroken() {
        String input = ".";
        if (!".".equals(IDN.toASCII("."))) {
            String[] props;
            System.out.println(">>DomainValidatorTest.testIsIDNtoASCIIBroken()");
            System.out.println("IDN.toASCII is BROKEN");
            for (String t : props = new String[]{"java.version", "java.vendor", "java.vm.specification.version", "java.vm.specification.vendor", "java.vm.specification.name", "java.vm.version", "java.vm.vendor", "java.vm.name", "java.specification.version", "java.specification.vendor", "java.specification.name", "java.class.version"}) {
                System.out.println(t + "=" + System.getProperty(t));
            }
            System.out.println("<<DomainValidatorTest.testIsIDNtoASCIIBroken()");
        }
        Assertions.assertTrue((boolean)true);
    }

    @Test
    void testRFC2396domainlabel() {
        Assertions.assertTrue((boolean)this.validator.isValid("a.ch"), (String)"a.ch should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("9.ch"), (String)"9.ch should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("az.ch"), (String)"az.ch should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("09.ch"), (String)"09.ch should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("9-1.ch"), (String)"9-1.ch should validate");
        Assertions.assertFalse((boolean)this.validator.isValid("91-.ch"), (String)"91-.ch should not validate");
        Assertions.assertFalse((boolean)this.validator.isValid("-.ch"), (String)"-.ch should not validate");
    }

    @Test
    void testRFC2396toplabel() {
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a.c"), (String)"a.c (alpha) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a.cc"), (String)"a.cc (alpha alpha) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a.c9"), (String)"a.c9 (alpha alphanum) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a.c-9"), (String)"a.c-9 (alpha - alphanum) should validate");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("a.c-z"), (String)"a.c-z (alpha - alpha) should validate");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("a.9c"), (String)"a.9c (alphanum alpha) should fail");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("a.c-"), (String)"a.c- (alpha -) should fail");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("a.-"), (String)"a.- (-) should fail");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("a.-9"), (String)"a.-9 (- alphanum) should fail");
    }

    @Test
    void testTopLevelDomains() {
        Assertions.assertTrue((boolean)this.validator.isValidInfrastructureTld(".arpa"), (String)".arpa should validate as iTLD");
        Assertions.assertFalse((boolean)this.validator.isValidInfrastructureTld(".com"), (String)".com shouldn't validate as iTLD");
        Assertions.assertTrue((boolean)this.validator.isValidGenericTld(".name"), (String)".name should validate as gTLD");
        Assertions.assertFalse((boolean)this.validator.isValidGenericTld(".us"), (String)".us shouldn't validate as gTLD");
        Assertions.assertTrue((boolean)this.validator.isValidCountryCodeTld(".uk"), (String)".uk should validate as ccTLD");
        Assertions.assertFalse((boolean)this.validator.isValidCountryCodeTld(".org"), (String)".org shouldn't validate as ccTLD");
        Assertions.assertTrue((boolean)this.validator.isValidTld(".COM"), (String)".COM should validate as TLD");
        Assertions.assertTrue((boolean)this.validator.isValidTld(".BiZ"), (String)".BiZ should validate as TLD");
        Assertions.assertFalse((boolean)this.validator.isValid(".nope"), (String)"invalid TLD shouldn't validate");
        Assertions.assertFalse((boolean)this.validator.isValid(""), (String)"empty string shouldn't validate as TLD");
        Assertions.assertFalse((boolean)this.validator.isValid(null), (String)"null shouldn't validate as TLD");
    }

    @Test
    void testUnicodeToASCII() {
        String[][] otherDots;
        String[] asciidots;
        for (String s : asciidots = new String[]{"", ",", ".", "a.", "a.b", "a..b", "a...b", ".a", "..a"}) {
            Assertions.assertEquals((Object)s, (Object)DomainValidator.unicodeToASCII((String)s));
        }
        for (String[] s : otherDots = new String[][]{{"b\u3002", "b."}, {"b\uff0e", "b."}, {"b\uff61", "b."}, {"\u3002", "."}, {"\uff0e", "."}, {"\uff61", "."}}) {
            Assertions.assertEquals((Object)s[1], (Object)DomainValidator.unicodeToASCII((String)s[0]));
        }
    }

    @Test
    void testValidator297() {
        Assertions.assertTrue((boolean)this.validator.isValid("xn--d1abbgf6aiiy.xn--p1ai"), (String)"xn--d1abbgf6aiiy.xn--p1ai should validate");
    }

    @Test
    void testValidator306() {
        String longString = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A";
        Assertions.assertEquals((int)63, (int)"abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A".length());
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.com"), (String)"63 chars label should validate");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789Ax.com"), (String)"64 chars label should fail");
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax("test.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A"), (String)"63 chars TLD should validate");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax("test.xabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A"), (String)"64 chars TLD should fail");
        String longDomain = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A.abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A." + "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz0123456789A".substring(0, 61);
        Assertions.assertEquals((int)253, (int)longDomain.length());
        Assertions.assertTrue((boolean)this.validator.isValidDomainSyntax(longDomain), (String)"253 chars domain should validate");
        Assertions.assertFalse((boolean)this.validator.isValidDomainSyntax(longDomain + "x"), (String)"254 chars domain should fail");
    }

    @Test
    void testValidDomains() {
        Assertions.assertTrue((boolean)this.validator.isValid("apache.org"), (String)"apache.org should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("www.google.com"), (String)"www.google.com should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("test-domain.com"), (String)"test-domain.com should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("test---domain.com"), (String)"test---domain.com should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("test-d-o-m-ain.com"), (String)"test-d-o-m-ain.com should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("as.uk"), (String)"two-letter domain label should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("ApAchE.Org"), (String)"case-insensitive ApAchE.Org should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("z.com"), (String)"single-character domain label should validate");
        Assertions.assertTrue((boolean)this.validator.isValid("i.have.an-example.domain.name"), (String)"i.have.an-example.domain.name should validate");
    }
}

