/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator.routines.checkdigit;

import org.apache.commons.validator.routines.checkdigit.AbstractCheckDigitTest;
import org.apache.commons.validator.routines.checkdigit.CASNumberCheckDigit;
import org.junit.jupiter.api.BeforeEach;

class CASNumberCheckDigitTest
extends AbstractCheckDigitTest {
    private static final String MIN = "00-01-1";
    private static final String WATER = "7732-18-5";
    private static final String ETHANOL = "64-17-5";
    private static final String ASPIRIN = "50-78-2";
    private static final String COFFEIN = "58-08-2";
    private static final String FORMALDEHYDE = "50-00-0";
    private static final String DEXAMETHASONE = "50-02-2";
    private static final String ARSENIC = "7440-38-2";
    private static final String ASBESTOS = "1332-21-4";
    private static final String MAX = "9999999-99-5";

    CASNumberCheckDigitTest() {
    }

    @Override
    protected String removeCheckDigit(String code) {
        String cde = (String)CASNumberCheckDigit.REGEX_VALIDATOR.validate(code);
        if (cde == null || cde.length() <= this.checkDigitLth) {
            return null;
        }
        return cde.substring(0, cde.length() - this.checkDigitLth);
    }

    @BeforeEach
    protected void setUp() {
        this.routine = CASNumberCheckDigit.getInstance();
        this.valid = new String[]{MIN, WATER, ETHANOL, ASPIRIN, COFFEIN, FORMALDEHYDE, DEXAMETHASONE, ARSENIC, ASBESTOS, MAX};
    }
}

