/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.commons.vfs2.provider.ftps;

/**
 * Protection level of the data channel in a FTPS communication.
 * <ul>
 * <li>C - Clear</li>
 * <li>S - Safe</li>
 * <li>E - Confidential</li>
 * <li>P - Private</li>
 * </ul>
 *
 * @see <a href="https://datatracker.ietf.org/doc/html/rfc2228#section-3">RFC 2228, section 3</a>
 * @since 2.1
 */
public enum FtpsDataChannelProtectionLevel {

    /** Clear. */
    C,

    /** Safe. */
    S,

    /** Confidential. */
    E,

    /** Private. */
    P
}
