/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.junit.Test;

public class VfsClassLoaderTests
extends AbstractProviderTestCase {
    private VFSClassLoader createClassLoader() throws FileSystemException {
        return new VFSClassLoader(this.getBaseFolder(), (FileSystemManager)this.getManager());
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.READ_CONTENT, Capability.URI};
    }

    @Test
    public void testGetResourcesJARs() throws Exception {
        DefaultFileSystemManager manager = this.getManager();
        try {
            manager.toFileObject(new File("."));
        }
        catch (FileSystemException e) {
            System.out.println("VfsClassLoaderTests no local file provider, skipping.");
            return;
        }
        File baseDir = VfsTestUtils.getTestDirectoryFile();
        FileObject nestedJar = manager.resolveFile(baseDir, "nested.jar");
        FileObject testJar = manager.resolveFile(baseDir, "test.jar");
        if (!manager.canCreateFileSystem(nestedJar)) {
            System.out.println("VfsClassLoaderTests no layered .jar provider, skipping.");
            return;
        }
        VfsClassLoaderTests.assertSame((String)"nested.jar is required for testing", (Object)nestedJar.getType(), (Object)FileType.FILE);
        VfsClassLoaderTests.assertSame((String)"test.jar is required for testing", (Object)testJar.getType(), (Object)FileType.FILE);
        MockClassloader mockClassloader = new MockClassloader();
        FileObject[] search = new FileObject[]{nestedJar, testJar};
        VFSClassLoader loader = new VFSClassLoader(search, (FileSystemManager)this.getManager(), (ClassLoader)mockClassloader);
        Enumeration urls = loader.getResources("META-INF/MANIFEST.MF");
        URL url1 = (URL)urls.nextElement();
        URL url2 = (URL)urls.nextElement();
        VfsClassLoaderTests.assertTrue((String)("First resource must refer to nested.jar but was " + url1), (boolean)url1.toString().endsWith("nested.jar!/META-INF/MANIFEST.MF"));
        VfsClassLoaderTests.assertTrue((String)("Second resource must refer to test.jar but was " + url2), (boolean)url2.toString().endsWith("test.jar!/META-INF/MANIFEST.MF"));
    }

    @Test
    public void testGetResourcesNoLayerLocal() throws Exception {
        DefaultFileSystemManager manager = this.getManager();
        try {
            manager.toFileObject(new File("."));
        }
        catch (FileSystemException e) {
            System.out.println("VfsClassLoaderTests no local file provider, skipping.");
            return;
        }
        File baseDir = VfsTestUtils.getTestDirectoryFile();
        FileObject dir = manager.resolveFile(baseDir, "read-tests/dir1/subdir4.jar");
        VfsClassLoaderTests.assertSame((String)("subdir4.jar/ is required for testing " + dir), (Object)dir.getType(), (Object)FileType.FOLDER);
        VfsClassLoaderTests.assertFalse((boolean)manager.canCreateFileSystem(dir));
        FileObject[] search = new FileObject[]{dir};
        MockClassloader mockClassloader = new MockClassloader();
        VFSClassLoader loader = new VFSClassLoader(search, (FileSystemManager)this.getManager(), (ClassLoader)mockClassloader);
        Enumeration urls = loader.getResources("file1.txt");
        URL url1 = (URL)urls.nextElement();
        VfsClassLoaderTests.assertFalse((String)"Only one hit expected", (boolean)urls.hasMoreElements());
        VfsClassLoaderTests.assertTrue((String)("not pointing to resource " + url1), (boolean)url1.toString().endsWith("subdir4.jar/file1.txt"));
    }

    @Test
    public void testLoadClass() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.ClassToLoad");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code", (String)pack.getName());
        this.verifyPackage(pack, false);
        Object testObject = testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        VfsClassLoaderTests.assertEquals((String)"**PRIVATE**", (String)testObject.toString());
    }

    @Test
    public void testLoadResource() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        URL resource = loader.getResource("read-tests/file1.txt");
        VfsClassLoaderTests.assertNotNull((Object)resource);
        URLConnection urlCon = resource.openConnection();
        this.assertSameURLContent("This is a test file.", urlCon);
    }

    @Test
    public void testSealing() throws Exception {
        VFSClassLoader loader = this.createClassLoader();
        Class testClass = loader.loadClass("code.sealed.AnotherClass");
        Package pack = testClass.getPackage();
        VfsClassLoaderTests.assertEquals((String)"code.sealed", (String)pack.getName());
        this.verifyPackage(pack, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThreadSafety() throws Exception {
        Object loader;
        int THREADS = 40;
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(80);
        ArrayList exceptions = new ArrayList();
        Thread.UncaughtExceptionHandler handler = (t, e) -> {
            List list = exceptions;
            synchronized (list) {
                exceptions.add(e);
            }
        };
        ThreadFactory factory = r -> {
            Thread thread = new Thread(r, "VfsClassLoaderTests.testThreadSafety");
            thread.setUncaughtExceptionHandler(handler);
            return thread;
        };
        LinkedList rejections = new LinkedList();
        RejectedExecutionHandler rejectionHandler = (r, executor) -> {
            Queue queue = rejections;
            synchronized (queue) {
                rejections.add(r);
            }
        };
        ThreadPoolExecutor executor2 = new ThreadPoolExecutor(40, 40, 0L, TimeUnit.SECONDS, workQueue, factory, rejectionHandler);
        executor2.prestartAllCoreThreads();
        for (int i = 0; i < 40; ++i) {
            loader = this.createClassLoader();
            workQueue.put(new LoadClass((VFSClassLoader)loader));
        }
        while (!workQueue.isEmpty()) {
            Thread.sleep(10L);
        }
        while (!rejections.isEmpty() && executor2.getActiveCount() > 0) {
            ArrayList rejected = new ArrayList();
            loader = rejections;
            synchronized (loader) {
                rejected.addAll(rejections);
                rejections.clear();
            }
            workQueue.addAll(rejected);
        }
        executor2.shutdown();
        executor2.awaitTermination(30L, TimeUnit.SECONDS);
        VfsClassLoaderTests.assertEquals((long)40L, (long)executor2.getCompletedTaskCount());
        if (!exceptions.isEmpty()) {
            StringBuilder exceptionMsg = new StringBuilder();
            StringBuilderWriter writer = new StringBuilderWriter(exceptionMsg);
            PrintWriter pWriter = new PrintWriter((Writer)writer);
            for (Throwable t2 : exceptions) {
                pWriter.write(t2.getMessage());
                pWriter.write(10);
                t2.printStackTrace(pWriter);
                pWriter.write(10);
            }
            pWriter.flush();
            VfsClassLoaderTests.assertTrue((String)(exceptions.size() + " threads failed: " + exceptionMsg), (boolean)exceptions.isEmpty());
        }
    }

    private void verifyPackage(Package pack, boolean sealed) {
        if (this.getBaseFolder().getFileSystem().hasCapability(Capability.MANIFEST_ATTRIBUTES)) {
            VfsClassLoaderTests.assertEquals((String)"ImplTitle", (String)pack.getImplementationTitle());
            VfsClassLoaderTests.assertEquals((String)"ImplVendor", (String)pack.getImplementationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.1", (String)pack.getImplementationVersion());
            VfsClassLoaderTests.assertEquals((String)"SpecTitle", (String)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertEquals((String)"SpecVendor", (String)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertEquals((String)"1.0", (String)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertEquals((boolean)sealed, (boolean)pack.isSealed());
        } else {
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getImplementationVersion());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationTitle());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVendor());
            VfsClassLoaderTests.assertNull((Object)pack.getSpecificationVersion());
            VfsClassLoaderTests.assertFalse((boolean)pack.isSealed());
        }
    }

    public static class MockClassloader
    extends ClassLoader {
        MockClassloader() {
            super(null);
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            TestCase.fail((String)"Not intended to be used for class loading.");
            return null;
        }

        @Override
        public Enumeration<URL> getResources(String name) {
            return Collections.enumeration(Collections.emptyList());
        }
    }

    private class LoadClass
    implements Runnable {
        private final VFSClassLoader loader;

        public LoadClass(VFSClassLoader loader) {
            this.loader = loader;
        }

        @Override
        public void run() {
            try {
                Class testClass = this.loader.findClass("code.ClassToLoad");
                Package pack = testClass.getPackage();
                TestCase.assertEquals((String)"code", (String)pack.getName());
                VfsClassLoaderTests.this.verifyPackage(pack, false);
                Object testObject = testClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                TestCase.assertEquals((String)"**PRIVATE**", (String)testObject.toString());
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

