/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.apache.commons.weaver.model.WeaveInterest;

public class ScanRequest {
    private final List<WeaveInterest> interests = new ArrayList<WeaveInterest>();
    private final Set<Class<?>> supertypes = new LinkedHashSet();

    public ScanRequest add(WeaveInterest interest) {
        if (interest == null) {
            throw new NullPointerException();
        }
        this.interests.add(interest);
        return this;
    }

    public ScanRequest addSupertypes(Class<?> ... types) {
        Collections.addAll(this.supertypes, Validate.noNullElements((Object[])types, (String)"null element at [%s]", (Object[])new Object[0]));
        return this;
    }

    public Iterable<WeaveInterest> getInterests() {
        return Collections.unmodifiableList(this.interests);
    }

    public Set<Class<?>> getSupertypes() {
        return Collections.unmodifiableSet(this.supertypes);
    }

    public boolean isConstrained() {
        return !this.interests.isEmpty() || !this.supertypes.isEmpty();
    }
}

