/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.rat.api.RatException;
import org.apache.rat.document.impl.FileDocument;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.walker.FileNameComparator;
import org.apache.rat.walker.Walker;

public class DirectoryWalker
extends Walker
implements IReportable {
    private static final FileNameComparator COMPARATOR = new FileNameComparator();
    private final IOFileFilter directoryFilter;

    public DirectoryWalker(File file, IOFileFilter directoryFilter) {
        this(file, (FilenameFilter)null, directoryFilter);
    }

    public DirectoryWalker(File file, FilenameFilter filter, IOFileFilter directoryFilter) {
        super(file.getPath(), file, filter);
        this.directoryFilter = directoryFilter;
    }

    public DirectoryWalker(File file, Pattern ignoreNameRegex, IOFileFilter directoryFilter) {
        super(file.getPath(), file, DirectoryWalker.regexFilter(ignoreNameRegex));
        this.directoryFilter = directoryFilter;
    }

    private void processDirectory(RatReport report, File file) throws RatException {
        if (this.directoryFilter != null) {
            if (!this.directoryFilter.accept(file)) {
                this.process(report, file);
            }
        } else {
            this.process(report, file);
        }
    }

    @Override
    public void run(RatReport report) throws RatException {
        this.process(report, this.file);
    }

    private void process(RatReport report, File file) throws RatException {
        File[] files = file.listFiles();
        if (files != null) {
            Arrays.sort(files, COMPARATOR);
            this.processNonDirectories(report, files);
            this.processDirectories(report, files);
        }
    }

    private void processDirectories(RatReport report, File[] files) throws RatException {
        for (File file : files) {
            if (!this.isNotIgnored(file) || !file.isDirectory()) continue;
            this.processDirectory(report, file);
        }
    }

    private void processNonDirectories(RatReport report, File[] files) throws RatException {
        for (File file : files) {
            if (!this.isNotIgnored(file) || file.isDirectory()) continue;
            this.report(report, file);
        }
    }

    private void report(RatReport report, File file) throws RatException {
        FileDocument document = new FileDocument(file);
        report.report(document);
    }
}

