/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.walker;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.rat.api.RatException;
import org.apache.rat.document.DocumentName;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;
import org.apache.rat.utils.DefaultLog;

public final class IReportableListWalker
implements IReportable {
    private final DocumentName documentName;
    private final List<IReportable> reportables;

    public static Builder builder(DocumentName name) {
        return new Builder(name);
    }

    private IReportableListWalker(Builder builder) {
        this.documentName = builder.documentName;
        this.reportables = builder.reportables;
    }

    @Override
    public void run(RatReport report) {
        for (IReportable reportable : this.reportables) {
            try {
                reportable.run(report);
            }
            catch (RatException e) {
                DefaultLog.getInstance().error("Error processing " + reportable.getName(), e);
            }
        }
    }

    @Override
    public DocumentName getName() {
        return this.documentName;
    }

    public static final class Builder {
        private final DocumentName documentName;
        private List<IReportable> reportables = new ArrayList<IReportable>();

        private Builder(DocumentName name) {
            Objects.requireNonNull(name, "Document name must not be null");
            this.documentName = name;
        }

        public Builder addReportable(IReportable reportable) {
            this.reportables.add(reportable);
            return this;
        }

        public IReportable build() throws RatException {
            if (this.reportables == null) {
                throw new RatException("Builder may only be used once");
            }
            IReportableListWalker result = new IReportableListWalker(this);
            this.reportables = null;
            return result;
        }
    }
}

