/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.chain.commands;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.chain.commands.ActionCommandBase;
import org.apache.struts.chain.contexts.ActionContext;
import org.apache.struts.chain.contexts.ServletActionContext;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.FormBeanConfig;

public class CreateActionForm
extends ActionCommandBase {
    private static final Log LOG = LogFactory.getLog(CreateActionForm.class);

    public boolean execute(ActionContext actionCtx) throws Exception {
        FormBeanConfig formBeanConfig;
        ActionConfig actionConfig = actionCtx.getActionConfig();
        String name = actionConfig.getName();
        if (name == null) {
            actionCtx.setActionForm(null);
            return false;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Look up form-bean " + name);
        }
        if ((formBeanConfig = actionConfig.getModuleConfig().findFormBeanConfig(name)) == null) {
            LOG.warn("No FormBeanConfig found in module " + actionConfig.getModuleConfig().getPrefix() + " under name " + name);
            actionCtx.setActionForm(null);
            return false;
        }
        Map scope = actionCtx.getScope(actionConfig.getScope());
        ActionForm instance = (ActionForm)scope.get(actionConfig.getAttribute());
        if (!formBeanConfig.canReuse(instance)) {
            instance = formBeanConfig.createActionForm(actionCtx);
        }
        if (actionCtx instanceof ServletActionContext) {
            ServletActionContext sac = (ServletActionContext)actionCtx;
            instance.setServlet(sac.getActionServlet());
        }
        actionCtx.setActionForm(instance);
        scope.put(actionConfig.getAttribute(), instance);
        return false;
    }
}

