/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.cxf;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import org.apache.cxf.jca.cxf.CXFWorkAdapter;
import org.eclipse.jetty.util.thread.ThreadPool;

public class WorkManagerThreadPool
extends CXFWorkAdapter
implements ThreadPool {
    private WorkManager workManager;
    private boolean isLowOnThreads;
    private Runnable theJob;

    public WorkManagerThreadPool(WorkManager wm) {
        this.workManager = wm;
    }

    public boolean dispatch(Runnable job) {
        try {
            this.theJob = job;
            this.workManager.startWork((Work)new WorkImpl(job), 60000L, null, (WorkListener)this);
            return true;
        }
        catch (WorkException e) {
            e.printStackTrace();
            return false;
        }
    }

    public int getIdleThreads() {
        return 0;
    }

    public int getThreads() {
        return 1;
    }

    public boolean isLowOnThreads() {
        return this.isLowOnThreads;
    }

    void setIsLowOnThreads(boolean isLow) {
        this.isLowOnThreads = isLow;
    }

    public void join() throws InterruptedException {
    }

    @Override
    public void workRejected(WorkEvent e) {
        super.workRejected(e);
        WorkException we = e.getException();
        if ("1".equals(we.getErrorCode()) && !this.isLowOnThreads) {
            this.setIsLowOnThreads(true);
            this.dispatch(this.theJob);
        }
    }

    public void execute(Runnable command) {
        this.dispatch(command);
    }

    public class WorkImpl
    implements Work {
        private Runnable job;

        public WorkImpl(Runnable job) {
            this.job = job;
        }

        public void run() {
            this.job.run();
        }

        public void release() {
        }
    }
}

