/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.httpsignature.filters.AbstractSignatureOutFilter;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

@Provider
@Priority(value=3000)
public class CreateSignatureInterceptor
extends AbstractSignatureOutFilter
implements WriterInterceptor,
ClientRequestFilter,
ContainerResponseFilter {
    private static final String DIGEST_HEADER_NAME = "Digest";
    private String digestAlgorithmName;
    @Context
    private UriInfo uriInfo;
    private boolean addDigest = true;

    public void aroundWriteTo(WriterInterceptorContext context) throws IOException {
        if (context.getEntity() != null) {
            if (this.addDigest && context.getHeaders().keySet().stream().noneMatch(DIGEST_HEADER_NAME::equalsIgnoreCase)) {
                this.addDigest(context);
            } else {
                this.sign(context);
                context.proceed();
            }
        }
    }

    public void filter(ClientRequestContext requestContext) {
        if (requestContext.getEntity() == null) {
            String method = requestContext.getMethod();
            this.performSignature((MultivaluedMap<String, Object>)requestContext.getHeaders(), SignatureHeaderUtils.createRequestTarget(requestContext.getUri()), method);
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (responseContext.getEntity() == null) {
            this.performSignature((MultivaluedMap<String, Object>)responseContext.getHeaders(), "", "");
        }
    }

    protected void sign(WriterInterceptorContext writerInterceptorContext) {
        Message m = JAXRSUtils.getCurrentMessage();
        String method = "";
        String path = "";
        if (MessageUtils.isRequestor((Message)m)) {
            method = HttpUtils.getProtocolHeader((Message)JAXRSUtils.getCurrentMessage(), (String)"org.apache.cxf.request.method", (String)"");
            path = SignatureHeaderUtils.createRequestTarget(this.uriInfo.getRequestUri());
        }
        this.performSignature((MultivaluedMap<String, Object>)writerInterceptorContext.getHeaders(), path, method);
    }

    private void addDigest(WriterInterceptorContext context) throws IOException {
        Message m;
        OutputStream originalOutputStream = context.getOutputStream();
        CachedOutputStream cachedOutputStream = new CachedOutputStream();
        context.setOutputStream((OutputStream)cachedOutputStream);
        context.proceed();
        cachedOutputStream.flush();
        String encoding = context.getMediaType().getParameters().getOrDefault("charset", StandardCharsets.UTF_8.toString());
        String digestAlgorithm = this.digestAlgorithmName;
        if (digestAlgorithm == null && (digestAlgorithm = (String)(m = PhaseInterceptorChain.getCurrentMessage()).getContextualProperty("rs.security.http.signature.digest.algorithm")) == null) {
            digestAlgorithm = "SHA-256";
        }
        String digest = SignatureHeaderUtils.createDigestHeader(new String(cachedOutputStream.getBytes(), encoding), digestAlgorithm);
        context.getHeaders().add((Object)DIGEST_HEADER_NAME, (Object)digest);
        this.sign(context);
        context.setOutputStream(originalOutputStream);
        IOUtils.copy((InputStream)cachedOutputStream.getInputStream(), (OutputStream)originalOutputStream);
    }

    public String getDigestAlgorithmName() {
        return this.digestAlgorithmName;
    }

    public void setDigestAlgorithmName(String digestAlgorithmName) {
        this.digestAlgorithmName = digestAlgorithmName;
    }

    public boolean isAddDigest() {
        return this.addDigest;
    }

    public void setAddDigest(boolean addDigest) {
        this.addDigest = addDigest;
    }
}

