/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.utils;

import org.apache.activemq.artemis.utils.HashProcessor;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.apache.activemq.artemis.utils.SensitiveDataCodec;

public class SecureHashProcessor
implements HashProcessor {
    private SensitiveDataCodec<String> codec;

    public SecureHashProcessor(SensitiveDataCodec<String> codec) {
        this.codec = codec;
    }

    @Override
    public String hash(String plainText) throws Exception {
        return PasswordMaskingUtil.wrap(this.codec.encode(plainText));
    }

    @Override
    public boolean compare(char[] inputValue, String storedValue) {
        String storedHash = storedValue.substring(4, storedValue.length() - 1);
        return this.codec.verify(inputValue, storedHash);
    }
}

