/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;

public class MBeanServerFactory {
    private boolean locateExistingServerIfPossible = false;
    private String defaultDomain;
    private boolean registerWithFactory = true;
    private MBeanServer server;
    private boolean newlyRegistered = false;

    public boolean isLocateExistingServerIfPossible() {
        return this.locateExistingServerIfPossible;
    }

    public void setLocateExistingServerIfPossible(boolean locateExistingServerIfPossible) {
        this.locateExistingServerIfPossible = locateExistingServerIfPossible;
    }

    public String getDefaultDomain() {
        return this.defaultDomain;
    }

    public void setDefaultDomain(String defaultDomain) {
        this.defaultDomain = defaultDomain;
    }

    public boolean isRegisterWithFactory() {
        return this.registerWithFactory;
    }

    public void setRegisterWithFactory(boolean registerWithFactory) {
        this.registerWithFactory = registerWithFactory;
    }

    public boolean isNewlyRegistered() {
        return this.newlyRegistered;
    }

    public void setNewlyRegistered(boolean newlyRegistered) {
        this.newlyRegistered = newlyRegistered;
    }

    public MBeanServer getServer() throws Exception {
        if (this.server == null) {
            this.init();
        }
        return this.server;
    }

    public void init() throws Exception {
        if (this.locateExistingServerIfPossible) {
            ArrayList<MBeanServer> servers = javax.management.MBeanServerFactory.findMBeanServer(null);
            if (servers != null && servers.size() > 0) {
                this.server = (MBeanServer)servers.get(0);
            }
            if (this.server == null) {
                this.server = ManagementFactory.getPlatformMBeanServer();
            }
            if (this.server == null) {
                throw new Exception("Unable to locate MBeanServer");
            }
        }
        if (this.server == null) {
            this.server = this.registerWithFactory ? javax.management.MBeanServerFactory.createMBeanServer(this.defaultDomain) : javax.management.MBeanServerFactory.newMBeanServer(this.defaultDomain);
            this.newlyRegistered = this.registerWithFactory;
        }
    }

    public void destroy() throws Exception {
        if (this.newlyRegistered) {
            javax.management.MBeanServerFactory.releaseMBeanServer(this.server);
        }
    }
}

