/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.multipart;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.core.ResolvableType;
import org.springframework.core.codec.DecodingException;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import org.springframework.http.codec.LoggingCodecSupport;
import org.springframework.http.codec.multipart.FileStorage;
import org.springframework.http.codec.multipart.MultipartParser;
import org.springframework.http.codec.multipart.MultipartUtils;
import org.springframework.http.codec.multipart.Part;
import org.springframework.http.codec.multipart.PartGenerator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public class DefaultPartHttpMessageReader
extends LoggingCodecSupport
implements HttpMessageReader<Part> {
    private int maxInMemorySize = 262144;
    private int maxHeadersSize = 10240;
    private long maxDiskUsagePerPart = -1L;
    private int maxParts = -1;
    private boolean streaming;
    private Scheduler blockingOperationScheduler = Schedulers.boundedElastic();
    private FileStorage fileStorage = FileStorage.tempDirectory(this::getBlockingOperationScheduler);
    private Charset headersCharset = StandardCharsets.UTF_8;

    public void setMaxHeadersSize(int byteCount) {
        this.maxHeadersSize = byteCount;
    }

    public int getMaxInMemorySize() {
        return this.maxInMemorySize;
    }

    public void setMaxInMemorySize(int maxInMemorySize) {
        this.maxInMemorySize = maxInMemorySize;
    }

    public void setMaxDiskUsagePerPart(long maxDiskUsagePerPart) {
        this.maxDiskUsagePerPart = maxDiskUsagePerPart;
    }

    public void setMaxParts(int maxParts) {
        this.maxParts = maxParts;
    }

    public void setFileStorageDirectory(Path fileStorageDirectory) throws IOException {
        Assert.notNull((Object)fileStorageDirectory, (String)"FileStorageDirectory must not be null");
        this.fileStorage = FileStorage.fromPath(fileStorageDirectory);
    }

    public void setBlockingOperationScheduler(Scheduler blockingOperationScheduler) {
        Assert.notNull((Object)blockingOperationScheduler, (String)"'blockingOperationScheduler' must not be null");
        this.blockingOperationScheduler = blockingOperationScheduler;
    }

    private Scheduler getBlockingOperationScheduler() {
        return this.blockingOperationScheduler;
    }

    @Deprecated(since="6.0", forRemoval=true)
    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public void setHeadersCharset(Charset headersCharset) {
        Assert.notNull((Object)headersCharset, (String)"HeadersCharset must not be null");
        this.headersCharset = headersCharset;
    }

    @Override
    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    @Override
    public boolean canRead(ResolvableType elementType, @Nullable MediaType mediaType) {
        return Part.class.equals((Object)elementType.toClass()) && (mediaType == null || MediaType.MULTIPART_FORM_DATA.isCompatibleWith(mediaType));
    }

    @Override
    public Mono<Part> readMono(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Mono.error((Throwable)new UnsupportedOperationException("Cannot read multipart request body into single Part"));
    }

    @Override
    public Flux<Part> read(ResolvableType elementType, ReactiveHttpInputMessage message, Map<String, Object> hints) {
        return Flux.defer(() -> {
            byte[] boundary = MultipartUtils.boundary(message, this.headersCharset);
            if (boundary == null) {
                return Flux.error((Throwable)new DecodingException("No multipart boundary found in Content-Type: \"" + message.getHeaders().getContentType() + "\""));
            }
            Flux<MultipartParser.Token> allPartsTokens = MultipartParser.parse(message.getBody(), boundary, this.maxHeadersSize, this.headersCharset);
            AtomicInteger partCount = new AtomicInteger();
            return allPartsTokens.windowUntil(MultipartParser.Token::isLast).concatMap(partsTokens -> {
                if (this.tooManyParts(partCount)) {
                    return Mono.error((Throwable)new DecodingException("Too many parts (" + partCount.get() + "/" + this.maxParts + " allowed)"));
                }
                return PartGenerator.createPart((Flux<MultipartParser.Token>)partsTokens, this.maxInMemorySize, this.maxDiskUsagePerPart, this.streaming, this.fileStorage.directory(), this.blockingOperationScheduler);
            });
        });
    }

    private boolean tooManyParts(AtomicInteger partCount) {
        int count = partCount.incrementAndGet();
        return this.maxParts > 0 && count > this.maxParts;
    }
}

