/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import io.netty.util.collection.LongObjectHashMap;
import java.lang.invoke.MethodHandles;
import java.util.function.Consumer;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.paging.impl.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageCache {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PagingStore owner;
    private final LongObjectHashMap<Page> usedPages = new LongObjectHashMap();

    public PageCache(PagingStore owner) {
        this.owner = owner;
    }

    public synchronized Page get(long pageID) {
        return (Page)this.usedPages.get(pageID);
    }

    public synchronized void forEachUsedPage(Consumer<Page> consumerPage) {
        this.usedPages.values().forEach(consumerPage);
    }

    public int size() {
        return this.usedPages.size();
    }

    public synchronized void injectPage(Page page) {
        if (logger.isDebugEnabled()) {
            logger.debug("+++ Injecting page {} on UsedPages for destination {}", (Object)page.getPageId(), (Object)this.owner.getAddress());
        }
        page.releaseTask(this::removePage);
        this.usedPages.put(page.getPageId(), (Object)page);
    }

    public synchronized void removePage(Page page) {
        if (this.usedPages.remove(page.getPageId()) != null && logger.isDebugEnabled()) {
            logger.debug("--- Releasing page {} on UsedPages for destination {}", (Object)page.getPageId(), (Object)this.owner.getAddress());
        }
    }
}

