/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.paging.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.paging.PagedMessage;
import org.apache.activemq.artemis.core.paging.impl.PagedMessageImpl;
import org.apache.activemq.artemis.core.persistence.OperationContext;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.utils.Env;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageReadWriter {
    private static Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int SIZE_RECORD = 6;
    private static final byte START_BYTE = 123;
    private static final byte END_BYTE = 125;
    private static final int HEADER_AND_TRAILER_SIZE = 6;
    private static final int MINIMUM_MSG_PERSISTENT_SIZE = 6;
    private static final int HEADER_SIZE = 5;
    private static final int MIN_CHUNK_SIZE = Env.osPageSize();
    public static final PageRecordFilter ONLY_LARGE = buffer -> !PagedMessageImpl.isLargeMessage(buffer);
    public static final PageRecordFilter NO_SKIP = buffer -> false;
    public static final PageRecordFilter SKIP_ALL = buffer -> true;

    public static int writeMessage(PagedMessage message, SequentialFileFactory fileFactory, SequentialFile file) throws Exception {
        int messageEncodedSize = message.getEncodeSize();
        int bufferSize = messageEncodedSize + 6;
        ByteBuffer buffer = fileFactory.newBuffer(bufferSize);
        ChannelBufferWrapper activeMQBuffer = new ChannelBufferWrapper(Unpooled.wrappedBuffer((ByteBuffer)buffer));
        activeMQBuffer.clear();
        activeMQBuffer.writeByte((byte)123);
        activeMQBuffer.writeInt(messageEncodedSize);
        message.encode((ActiveMQBuffer)activeMQBuffer);
        activeMQBuffer.writeByte((byte)125);
        assert (activeMQBuffer.readableBytes() == bufferSize) : "messageEncodedSize is different from expected";
        assert (buffer.remaining() == bufferSize) : "buffer position or limit are changed";
        if (fileFactory.supportsIndividualContext()) {
            OperationContext context = OperationContextImpl.getContext();
            if (context != null) {
                context.storeLineUp();
            }
            file.writeDirect(buffer, false, (IOCallback)context);
        } else {
            file.writeDirect(buffer, false);
        }
        return bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChannelBufferWrapper wrapWhole(ByteBuffer fileBuffer) {
        int position = fileBuffer.position();
        int limit = fileBuffer.limit();
        int capacity = fileBuffer.capacity();
        try {
            ChannelBufferWrapper fileBufferWrapper;
            fileBuffer.clear();
            ByteBuf wrappedBuffer = Unpooled.wrappedBuffer((ByteBuffer)fileBuffer);
            assert (wrappedBuffer.readableBytes() == capacity);
            ChannelBufferWrapper channelBufferWrapper = fileBufferWrapper = new ChannelBufferWrapper(wrappedBuffer);
            return channelBufferWrapper;
        }
        finally {
            fileBuffer.position(position);
            fileBuffer.limit(limit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int readFromSequentialFile(StorageManager storage, SimpleString storeName, SequentialFileFactory fileFactory, SequentialFile file, long pageId, Consumer<PagedMessage> messages, PageRecordFilter skipRecord, SuspectFileCallback suspectFileCallback, ReadCallback readCallback) throws Exception {
        block33: {
            block32: {
                block31: {
                    block30: {
                        fileSize = (int)file.size();
                        file.position(0L);
                        processedBytes = 0;
                        fileBuffer = null;
                        totalMessageCount = 0;
                        try {
                            remainingBytes = fileSize - processedBytes;
                            if (remainingBytes < 6) ** GOTO lbl91
                            fileBuffer = fileFactory.newBuffer(Math.min(remainingBytes, PageReadWriter.MIN_CHUNK_SIZE));
                            fileBufferWrapper = PageReadWriter.wrapWhole(fileBuffer);
                            fileBuffer.limit(0);
                            while (true) {
                                oldFileBuffer = fileBuffer;
                                if ((fileBuffer = PageReadWriter.readIntoFileBufferIfNecessary(fileFactory, file, fileBuffer, 6, false)) != oldFileBuffer) {
                                    fileBufferWrapper = PageReadWriter.wrapWhole(fileBuffer);
                                }
                                if ((startByte = fileBuffer.get()) != 123) ** GOTO lbl-1000
                                encodedSize = fileBuffer.getInt();
                                nextPosition = processedBytes + 6 + encodedSize;
                                if (nextPosition <= fileSize) {
                                    currentFileBuffer = fileBuffer;
                                    if ((fileBuffer = PageReadWriter.readIntoFileBufferIfNecessary(fileFactory, file, fileBuffer, encodedSize + 1, false)) != currentFileBuffer) {
                                        fileBufferWrapper = PageReadWriter.wrapWhole(fileBuffer);
                                    }
                                    endPosition = fileBuffer.position() + encodedSize;
                                    if (fileBuffer.remaining() >= encodedSize + 1 && fileBuffer.get(endPosition) == 125) {
                                        fileBufferWrapper.setIndex(fileBuffer.position(), endPosition);
                                        skipMessage = skipRecord.skip((ActiveMQBuffer)fileBufferWrapper);
                                        if (!skipMessage) {
                                            msg = new PagedMessageImpl(encodedSize, storage);
                                            msg.decode((ActiveMQBuffer)fileBufferWrapper);
                                            if (!PageReadWriter.$assertionsDisabled && fileBuffer.get(endPosition) != 125) {
                                                throw new AssertionError((Object)"decoding cannot change end byte");
                                            }
                                            msg.initMessage(storage);
                                            if (!PageReadWriter.$assertionsDisabled && !PageReadWriter.validateLargeMessageStorageManager(msg)) {
                                                throw new AssertionError();
                                            }
                                            if (PageReadWriter.logger.isTraceEnabled()) {
                                                PageReadWriter.logger.trace("Reading message {} on pageId={} for address={}", new Object[]{msg, pageId, storeName});
                                            }
                                            if (messages != null) {
                                                messages.accept(msg);
                                            }
                                            msg.setPageNumber(pageId).setMessageNumber(totalMessageCount);
                                        }
                                        ++totalMessageCount;
                                        fileBuffer.position(endPosition + 1);
                                        processedBytes = nextPosition;
                                        continue;
                                    }
                                    if (suspectFileCallback != null) {
                                        suspectFileCallback.onSuspect(file.getFileName(), processedBytes, totalMessageCount + 1);
                                    }
                                    var22_23 = totalMessageCount;
                                    if (fileBuffer == null) break block30;
                                }
                                ** GOTO lbl-1000
                                break;
                            }
                        }
                        catch (Throwable var24_25) {
                            if (fileBuffer != null) {
                                fileFactory.releaseBuffer(fileBuffer);
                            }
                            if (readCallback != null) {
                                readCallback.readComple(processedBytes);
                            }
                            if (file.position() != (long)processedBytes) {
                                file.position((long)processedBytes);
                            }
                            throw var24_25;
                        }
                        fileFactory.releaseBuffer(fileBuffer);
                    }
                    if (readCallback != null) {
                        readCallback.readComple(processedBytes);
                    }
                    if (file.position() != (long)processedBytes) {
                        file.position((long)processedBytes);
                    }
                    return var22_23;
lbl-1000:
                    // 1 sources

                    {
                        if (suspectFileCallback != null) {
                            suspectFileCallback.onSuspect(file.getFileName(), processedBytes, totalMessageCount + 1);
                        }
                        var20_21 = totalMessageCount;
                        if (fileBuffer == null) break block31;
                    }
                    fileFactory.releaseBuffer(fileBuffer);
                }
                if (readCallback != null) {
                    readCallback.readComple(processedBytes);
                }
                if (file.position() != (long)processedBytes) {
                    file.position((long)processedBytes);
                }
                return var20_21;
lbl-1000:
                // 1 sources

                {
                    if (suspectFileCallback != null) {
                        suspectFileCallback.onSuspect(file.getFileName(), processedBytes, totalMessageCount + 1);
                    }
                    var18_18 = totalMessageCount;
                    if (fileBuffer == null) break block32;
                }
                fileFactory.releaseBuffer(fileBuffer);
            }
            if (readCallback != null) {
                readCallback.readComple(processedBytes);
            }
            if (file.position() != (long)processedBytes) {
                file.position((long)processedBytes);
            }
            return var18_18;
            {
                if ((remainingBytes = fileSize - processedBytes) >= 6) ** continue;
lbl91:
                // 2 sources

                if (PageReadWriter.logger.isTraceEnabled()) {
                    PageReadWriter.logger.trace("{} has {} bytes of unknown data at position = {}", new Object[]{file.getFileName(), remainingBytes, processedBytes});
                }
                var16_16 = totalMessageCount;
                if (fileBuffer == null) break block33;
            }
            fileFactory.releaseBuffer(fileBuffer);
        }
        if (readCallback != null) {
            readCallback.readComple(processedBytes);
        }
        if (file.position() != (long)processedBytes) {
            file.position((long)processedBytes);
        }
        return var16_16;
    }

    private static ByteBuffer readIntoFileBufferIfNecessary(SequentialFileFactory fileFactory, SequentialFile file, ByteBuffer fileBuffer, int requiredBytes, boolean direct) throws Exception {
        int remaining = fileBuffer.remaining();
        int bytesToBeRead = requiredBytes - remaining;
        if (bytesToBeRead > 0) {
            int capacity = fileBuffer.capacity();
            if (capacity >= requiredBytes) {
                if (fileBuffer.limit() > 0) {
                    fileBuffer.compact();
                } else {
                    fileBuffer.limit(capacity);
                }
                file.read(fileBuffer);
                fileBuffer.position(0);
            } else {
                fileBuffer = PageReadWriter.allocateAndReadIntoFileBuffer(fileFactory, file, fileBuffer, requiredBytes, direct);
            }
        }
        return fileBuffer;
    }

    private static ByteBuffer allocateAndReadIntoFileBuffer(SequentialFileFactory fileFactory, SequentialFile file, ByteBuffer fileBuffer, int requiredBytes, boolean direct) throws Exception {
        ByteBuffer newFileBuffer;
        if (direct) {
            newFileBuffer = fileFactory.allocateDirectBuffer(Math.max(requiredBytes, MIN_CHUNK_SIZE));
            newFileBuffer.put(fileBuffer);
            fileFactory.releaseDirectBuffer(fileBuffer);
        } else {
            newFileBuffer = fileFactory.newBuffer(Math.max(requiredBytes, MIN_CHUNK_SIZE));
            newFileBuffer.put(fileBuffer);
            fileFactory.releaseBuffer(fileBuffer);
        }
        fileBuffer = newFileBuffer;
        fileBuffer.limit(fileBuffer.capacity());
        file.read(fileBuffer);
        fileBuffer.position(0);
        return fileBuffer;
    }

    private static boolean validateLargeMessageStorageManager(PagedMessage msg) {
        boolean storageManager;
        if (!(msg.getMessage() instanceof LargeServerMessage)) {
            return true;
        }
        LargeServerMessage largeServerMessage = (LargeServerMessage)msg.getMessage();
        boolean bl = storageManager = largeServerMessage.getStorageManager() != null;
        if (!storageManager) {
            logger.warn("storage manager is null at {}", (Object)msg);
        }
        return storageManager;
    }

    public static interface PageRecordFilter {
        public boolean skip(ActiveMQBuffer var1);
    }

    public static interface SuspectFileCallback {
        public void onSuspect(String var1, int var2, int var3);
    }

    public static interface ReadCallback {
        public void readComple(int var1);
    }
}

