/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.services.AbstractAccessTokenValidator;
import org.apache.cxf.rs.security.oauth2.utils.AuthorizationUtils;

@Path(value="validate")
public class AccessTokenValidatorService
extends AbstractAccessTokenValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(AccessTokenValidatorService.class);
    private boolean blockUnsecureRequests;
    private boolean blockUnauthorizedRequests = true;

    @POST
    @Produces(value={"application/xml", "application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public AccessTokenValidation getTokenValidationInfo(@Encoded MultivaluedMap<String, String> params) {
        this.checkSecurityContext();
        String authScheme = (String)params.getFirst((Object)"authScheme");
        String authSchemeData = (String)params.getFirst((Object)"authSchemeData");
        try {
            return super.getAccessTokenValidation(authScheme, authSchemeData, params);
        }
        catch (NotAuthorizedException ex) {
            AccessTokenValidation v = new AccessTokenValidation();
            v.setInitialValidationSuccessful(false);
            return v;
        }
    }

    private void checkSecurityContext() {
        SecurityContext sc = this.getMessageContext().getSecurityContext();
        if (!sc.isSecure() && this.blockUnsecureRequests) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
        if (sc.getUserPrincipal() == null && this.blockUnauthorizedRequests) {
            LOG.warning("Authenticated Principal is not available");
            AuthorizationUtils.throwAuthorizationFailure(this.supportedSchemes, this.realm);
        }
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }

    public void setBlockUnauthorizedRequests(boolean blockUnauthorizedRequests) {
        this.blockUnauthorizedRequests = blockUnauthorizedRequests;
    }
}

