/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.rs.security.jose.jwa.ContentAlgorithm;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

class EcdhHelper {
    private final ECPublicKey peerPublicKey;
    private final String ecurve;
    private final byte[] apuBytes;
    private final byte[] apvBytes;
    private final String ctAlgo;

    EcdhHelper(ECPublicKey peerPublicKey, String curve, String apuString, String apvString, String ctAlgo) {
        this.ctAlgo = ctAlgo;
        this.peerPublicKey = peerPublicKey;
        this.ecurve = curve;
        this.apuBytes = this.toApuBytes(apuString);
        this.apvBytes = this.toBytes(apvString);
    }

    public byte[] getDerivedKey(JweHeaders headers) {
        int keySizeBits;
        KeyPair pair = CryptoUtils.generateECKeyPair((String)this.ecurve);
        ECPublicKey publicKey = (ECPublicKey)pair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey)pair.getPrivate();
        KeyAlgorithm keyAlgo = headers.getKeyEncryptionAlgorithm();
        ContentAlgorithm contentAlgo = ContentAlgorithm.valueOf(this.ctAlgo);
        String algorithm = KeyAlgorithm.isDirect(keyAlgo) ? contentAlgo.getJwaName() : keyAlgo.getJwaName();
        int n = keySizeBits = KeyAlgorithm.isDirect(keyAlgo) ? contentAlgo.getKeySizeBits() : keyAlgo.getKeySizeBits();
        if (this.apuBytes != null) {
            headers.setHeader("apu", Base64UrlUtility.encode((byte[])this.apuBytes));
        }
        if (this.apvBytes != null) {
            headers.setHeader("apv", Base64UrlUtility.encode((byte[])this.apvBytes));
        }
        headers.setJsonWebKey("epk", JwkUtils.fromECPublicKey(publicKey, this.ecurve));
        return JweUtils.getECDHKey(privateKey, this.peerPublicKey, this.apuBytes, this.apvBytes, algorithm, keySizeBits);
    }

    private byte[] toApuBytes(String apuString) {
        if (apuString != null) {
            return this.toBytes(apuString);
        }
        return CryptoUtils.generateSecureRandomBytes((int)64);
    }

    private byte[] toBytes(String str) {
        return str == null ? null : StringUtils.toBytesUTF8((String)str);
    }
}

