/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.util.date.XsDateFormat;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;

public class DateType
extends AegisType {
    private static XsDateFormat format = new XsDateFormat();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        String value = reader.getValue();
        if (value == null) {
            return null;
        }
        try {
            XsDateFormat xsDateFormat = format;
            synchronized (xsDateFormat) {
                return ((Calendar)format.parseObject(value.trim())).getTime();
            }
        }
        catch (ParseException e) {
            throw new DatabindingException("Could not parse xs:dat: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) {
        Calendar c = Calendar.getInstance();
        c.setTime((Date)object);
        XsDateFormat xsDateFormat = format;
        synchronized (xsDateFormat) {
            writer.writeValue(format.format(c));
        }
    }
}

