/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class DisconnectMessage
extends PacketImpl {
    protected SimpleString nodeID;

    public DisconnectMessage(SimpleString nodeID) {
        super((byte)11);
        this.nodeID = nodeID;
    }

    public DisconnectMessage() {
        super((byte)11);
    }

    public DisconnectMessage(byte disconnectV2) {
        super(disconnectV2);
    }

    public SimpleString getNodeID() {
        return this.nodeID;
    }

    @Override
    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeNullableSimpleString(this.nodeID);
    }

    @Override
    public void decodeRest(ActiveMQBuffer buffer) {
        this.nodeID = buffer.readNullableSimpleString();
    }

    @Override
    protected String getPacketString() {
        StringBuffer buff = new StringBuffer(super.getPacketString());
        buff.append(", nodeID=" + this.nodeID);
        return buff.toString();
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.nodeID == null ? 0 : this.nodeID.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DisconnectMessage)) {
            return false;
        }
        DisconnectMessage other = (DisconnectMessage)obj;
        return !(this.nodeID == null ? other.nodeID != null : !this.nodeID.equals((Object)other.nodeID));
    }
}

