/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple.adouble;

import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.UpdatableSummary;

public final class DoubleSummary
implements UpdatableSummary<Double> {
    private double value_;
    private final Mode mode_;
    private static final int SERIALIZED_SIZE_BYTES = 9;
    private static final int VALUE_INDEX = 0;
    private static final int MODE_BYTE_INDEX = 8;

    private DoubleSummary(double value, Mode mode) {
        this.value_ = value;
        this.mode_ = mode;
    }

    public DoubleSummary(Mode mode) {
        this.mode_ = mode;
        switch (mode.ordinal()) {
            case 0: {
                this.value_ = 0.0;
                break;
            }
            case 1: {
                this.value_ = Double.POSITIVE_INFINITY;
                break;
            }
            case 2: {
                this.value_ = Double.NEGATIVE_INFINITY;
                break;
            }
            case 3: {
                this.value_ = 1.0;
            }
        }
    }

    public DoubleSummary update(Double value) {
        switch (this.mode_.ordinal()) {
            case 0: {
                this.value_ += value.doubleValue();
                break;
            }
            case 1: {
                if (!(value < this.value_)) break;
                this.value_ = value;
                break;
            }
            case 2: {
                if (!(value > this.value_)) break;
                this.value_ = value;
                break;
            }
            case 3: {
                this.value_ = 1.0;
            }
        }
        return this;
    }

    @Override
    public DoubleSummary copy() {
        return new DoubleSummary(this.value_, this.mode_);
    }

    public double getValue() {
        return this.value_;
    }

    @Override
    public byte[] toByteArray() {
        byte[] bytes = new byte[9];
        ByteArrayUtil.putDoubleLE(bytes, 0, this.value_);
        bytes[8] = (byte)this.mode_.ordinal();
        return bytes;
    }

    public static DeserializeResult<DoubleSummary> fromMemory(Memory mem) {
        return new DeserializeResult<DoubleSummary>(new DoubleSummary(mem.getDouble(0L), Mode.values()[mem.getByte(8L)]), 9);
    }

    public static enum Mode {
        Sum,
        Min,
        Max,
        AlwaysOne;

    }
}

