/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.config.view;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.api.config.view.metadata.CallbackDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.ConfigDescriptor;
import org.apache.deltaspike.core.api.config.view.metadata.DefaultCallback;
import org.apache.deltaspike.core.api.config.view.metadata.ExecutableCallbackDescriptor;

abstract class AbstractPathConfigDescriptor<CT>
implements ConfigDescriptor<CT> {
    private final Class<? extends CT> source;
    private List<Annotation> metaData;
    private Map<Class<? extends Annotation>, List<CallbackDescriptor>> callbackDescriptors;

    AbstractPathConfigDescriptor(Class<? extends CT> configClass, List<Annotation> mergedMetaData, Map<Class<? extends Annotation>, List<CallbackDescriptor>> callbackDescriptors) {
        this.source = configClass;
        this.metaData = Collections.unmodifiableList(mergedMetaData);
        this.callbackDescriptors = callbackDescriptors;
    }

    public Class<? extends CT> getConfigClass() {
        return this.source;
    }

    public List<Annotation> getMetaData() {
        return this.metaData;
    }

    public <T extends Annotation> List<T> getMetaData(Class<T> target) {
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation annotation : this.metaData) {
            if (!target.isAssignableFrom(annotation.annotationType())) continue;
            result.add(annotation);
        }
        return result;
    }

    public CallbackDescriptor getCallbackDescriptor(Class<? extends Annotation> metaDataType) {
        return this.getCallbackDescriptor(metaDataType, DefaultCallback.class);
    }

    public CallbackDescriptor getCallbackDescriptor(Class<? extends Annotation> metaDataType, Class<? extends Annotation> callbackType) {
        return this.findCallbackDescriptor(metaDataType, callbackType);
    }

    public <T extends ExecutableCallbackDescriptor> T getExecutableCallbackDescriptor(Class<? extends Annotation> metaDataType, Class<? extends T> executorType) {
        return this.getExecutableCallbackDescriptor(metaDataType, DefaultCallback.class, executorType);
    }

    public <T extends ExecutableCallbackDescriptor> T getExecutableCallbackDescriptor(Class<? extends Annotation> metaDataType, Class<? extends Annotation> callbackType, Class<? extends T> executorType) {
        return (T)((ExecutableCallbackDescriptor)this.findCallbackDescriptor(metaDataType, callbackType));
    }

    private <T extends CallbackDescriptor> T findCallbackDescriptor(Class<? extends Annotation> metaDataType, Class<? extends Annotation> callbackType) {
        List<CallbackDescriptor> foundDescriptors = this.callbackDescriptors.get(metaDataType);
        if (foundDescriptors == null || foundDescriptors.isEmpty()) {
            return null;
        }
        if (callbackType == null || DefaultCallback.class.equals(callbackType)) {
            if (foundDescriptors.size() > 1) {
                throw new IllegalStateException("multiple descriptors for " + (callbackType == null ? DefaultCallback.class.getName() : callbackType.getName()) + " aren't allowed");
            }
            return (T)foundDescriptors.iterator().next();
        }
        for (CallbackDescriptor callbackDescriptor : foundDescriptors) {
            if (!callbackDescriptor.isBoundTo(callbackType)) continue;
            return (T)callbackDescriptor;
        }
        return null;
    }

    public String toString() {
        return this.getPath();
    }
}

