/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.listener.phase;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.inject.Inject;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.jsf.api.listener.phase.AfterPhase;
import org.apache.deltaspike.jsf.api.listener.phase.BeforePhase;
import org.apache.deltaspike.jsf.api.listener.phase.JsfPhaseId;
import org.apache.deltaspike.jsf.api.listener.phase.JsfPhaseListener;
import org.apache.deltaspike.jsf.impl.listener.phase.AfterPhaseBinding;
import org.apache.deltaspike.jsf.impl.listener.phase.BeforePhaseBinding;

@ApplicationScoped
public class JsfRequestLifecycleBroadcaster {
    @Inject
    private Event<PhaseEvent> phaseEvent;
    @Inject
    @BeforePhase(value=JsfPhaseId.ANY_PHASE)
    private Event<PhaseEvent> beforeAnyPhaseEvent;
    @Inject
    @AfterPhase(value=JsfPhaseId.ANY_PHASE)
    private Event<PhaseEvent> afterAnyPhaseEvent;
    private List<PhaseListener> phaseListeners = new ArrayList<PhaseListener>();

    protected JsfRequestLifecycleBroadcaster() {
    }

    @Inject
    protected JsfRequestLifecycleBroadcaster(Instance<PhaseListener> phaseListenerInstance) {
        for (PhaseListener currentPhaseListener : phaseListenerInstance) {
            Class phaseListenerClass = ProxyUtils.getUnproxiedClass(currentPhaseListener.getClass());
            if (!phaseListenerClass.isAnnotationPresent(JsfPhaseListener.class) || Deactivatable.class.isAssignableFrom(phaseListenerClass) && !ClassDeactivationUtils.isActivated((Class)phaseListenerClass)) continue;
            this.phaseListeners.add(currentPhaseListener);
        }
        JsfRequestLifecycleBroadcaster.sortDescending(this.phaseListeners);
    }

    private static void sortDescending(List<PhaseListener> phaseListeners) {
        Collections.sort(phaseListeners, new Comparator<PhaseListener>(){

            @Override
            public int compare(PhaseListener phaseListener1, PhaseListener phaseListener2) {
                return phaseListener1.getClass().getAnnotation(JsfPhaseListener.class).ordinal() > phaseListener2.getClass().getAnnotation(JsfPhaseListener.class).ordinal() ? -1 : 1;
            }
        });
    }

    protected void broadcastBeforeEvent(PhaseEvent phaseEvent) {
        this.phaseEvent.select(new Annotation[]{this.createAnnotationLiteral(phaseEvent.getPhaseId(), true)}).fire((Object)phaseEvent);
        this.beforeAnyPhaseEvent.fire((Object)phaseEvent);
        for (PhaseListener phaseListener : this.phaseListeners) {
            PhaseId targetPhase = phaseListener.getPhaseId();
            if (targetPhase != PhaseId.ANY_PHASE && targetPhase != phaseEvent.getPhaseId()) continue;
            phaseListener.beforePhase(phaseEvent);
        }
    }

    protected void broadcastAfterEvent(PhaseEvent phaseEvent) {
        this.phaseEvent.select(new Annotation[]{this.createAnnotationLiteral(phaseEvent.getPhaseId(), false)}).fire((Object)phaseEvent);
        this.afterAnyPhaseEvent.fire((Object)phaseEvent);
        ListIterator<PhaseListener> phaseListenerIterator = this.phaseListeners.listIterator(this.phaseListeners.size());
        while (phaseListenerIterator.hasPrevious()) {
            PhaseListener phaseListener = phaseListenerIterator.previous();
            PhaseId targetPhase = phaseListener.getPhaseId();
            if (targetPhase != PhaseId.ANY_PHASE && targetPhase != phaseEvent.getPhaseId()) continue;
            phaseListener.afterPhase(phaseEvent);
        }
    }

    protected Annotation createAnnotationLiteral(PhaseId phaseId, boolean isBeforeEvent) {
        if (isBeforeEvent) {
            return this.createBeforeLiteral(phaseId);
        }
        return this.createAfterLiteral(phaseId);
    }

    protected Annotation createBeforeLiteral(final PhaseId phaseId) {
        return new BeforePhaseBinding(){
            private static final long serialVersionUID = 749645435335842723L;

            public JsfPhaseId value() {
                return JsfPhaseId.convertFromFacesClass((PhaseId)phaseId);
            }
        };
    }

    protected Annotation createAfterLiteral(final PhaseId phaseId) {
        return new AfterPhaseBinding(){
            private static final long serialVersionUID = 390037768660184656L;

            public JsfPhaseId value() {
                return JsfPhaseId.convertFromFacesClass((PhaseId)phaseId);
            }
        };
    }
}

