/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.scope.mapped;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.apache.deltaspike.core.util.metadata.AnnotationInstanceProvider;

class Jsf2BeanWrapper
implements AnnotatedType<Object> {
    private final AnnotatedType wrapped;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Set<Annotation> annotationSet;

    Jsf2BeanWrapper(AnnotatedType wrapped, Class<? extends Annotation> cdiScopeAnnotation, Class<? extends Annotation> jsf2ScopeAnnotation) {
        this.wrapped = wrapped;
        Set originalAnnotationSet = wrapped.getAnnotations();
        this.annotations = new HashMap<Class<? extends Annotation>, Annotation>(originalAnnotationSet.size());
        for (Annotation originalAnnotation : originalAnnotationSet) {
            if (originalAnnotation.annotationType().equals(jsf2ScopeAnnotation)) continue;
            this.annotations.put(originalAnnotation.annotationType(), originalAnnotation);
        }
        this.annotations.put(cdiScopeAnnotation, AnnotationInstanceProvider.of(cdiScopeAnnotation));
        this.annotationSet = new HashSet<Annotation>(this.annotations.size());
        this.annotationSet.addAll(this.annotations.values());
    }

    public Class getJavaClass() {
        return this.wrapped.getJavaClass();
    }

    public Set getConstructors() {
        return this.wrapped.getConstructors();
    }

    public Set getMethods() {
        return this.wrapped.getMethods();
    }

    public Set getFields() {
        return this.wrapped.getFields();
    }

    public Type getBaseType() {
        return this.wrapped.getBaseType();
    }

    public Set<Type> getTypeClosure() {
        return this.wrapped.getTypeClosure();
    }

    public <T extends Annotation> T getAnnotation(Class<T> targetClass) {
        return (T)this.annotations.get(targetClass);
    }

    public Set<Annotation> getAnnotations() {
        return this.annotationSet;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> targetClass) {
        return this.annotations.containsKey(targetClass);
    }
}

