/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.api.config;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.config.DeltaSpikeConfig;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindowConfig;

@ApplicationScoped
public class JsfModuleConfig
implements DeltaSpikeConfig {
    public static final String CLIENT_WINDOW_CONFIG_KEY = "javax.faces.CLIENT_WINDOW_MODE";
    public static final String CLIENT_WINDOW_CLASS_NAME = "javax.faces.lifecycle.ClientWindow";
    private static final long serialVersionUID = -487295181899986237L;
    private volatile Boolean initialized;
    private boolean delegatedWindowHandlingEnabled;
    private boolean jsf22Available;

    protected JsfModuleConfig() {
    }

    public boolean isInitialRedirectEnabled() {
        return true;
    }

    public boolean isAlwaysKeepMessages() {
        return true;
    }

    public boolean isAlwaysUseNavigationHandlerOnSecurityViolation() {
        return false;
    }

    public boolean isContainerManagedConvertersEnabled() {
        return true;
    }

    public boolean isContainerManagedValidatorsEnabled() {
        return true;
    }

    public boolean isFullStateSavingFallbackEnabled() {
        return true;
    }

    public ClientWindowConfig.ClientWindowRenderMode getDefaultWindowMode() {
        this.lazyInit();
        if (this.delegatedWindowHandlingEnabled) {
            return ClientWindowConfig.ClientWindowRenderMode.DELEGATED;
        }
        return null;
    }

    public Class<? extends Annotation> getExceptionQualifier() {
        return Default.class;
    }

    public boolean isAllowPostRequestWithoutDoubleSubmitPrevention() {
        return true;
    }

    public boolean isJsf22Available() {
        this.lazyInit();
        return this.jsf22Available;
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    protected synchronized void init() {
        if (this.initialized == null) {
            String initParam;
            FacesContext facesContext;
            boolean bl = this.jsf22Available = ClassUtils.tryToLoadClassForName((String)CLIENT_WINDOW_CLASS_NAME) != null;
            this.delegatedWindowHandlingEnabled = !this.jsf22Available ? false : ((facesContext = FacesContext.getCurrentInstance()) == null ? false : (initParam = facesContext.getExternalContext().getInitParameter(CLIENT_WINDOW_CONFIG_KEY)) != null && !"none".equalsIgnoreCase(initParam.trim()));
            this.initialized = true;
        }
    }
}

