/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.jsf.impl.view;

import java.lang.annotation.Annotation;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewHandlerWrapper;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.jsf.impl.security.SecurityAwareViewHandler;
import org.apache.deltaspike.jsf.impl.util.ClientWindowHelper;
import org.apache.deltaspike.jsf.spi.scope.window.ClientWindow;

public class DeltaSpikeViewHandler
extends ViewHandlerWrapper
implements Deactivatable {
    protected final ViewHandler wrapped;
    private volatile Boolean initialized;
    private ViewHandler securityAwareViewHandler;
    private ClientWindow clientWindow;

    public DeltaSpikeViewHandler(ViewHandler wrapped) {
        this.wrapped = wrapped;
    }

    protected ViewHandler createSecurityAwareViewHandler() {
        return new SecurityAwareViewHandler(this.wrapped);
    }

    public UIViewRoot createView(FacesContext facesContext, String viewId) {
        this.lazyInit();
        if (this.securityAwareViewHandler == null) {
            return this.wrapped.createView(facesContext, viewId);
        }
        return this.securityAwareViewHandler.createView(facesContext, viewId);
    }

    public String getActionURL(FacesContext context, String viewId) {
        this.lazyInit();
        String actionURL = this.wrapped.getActionURL(context, viewId);
        return ClientWindowHelper.appendWindowId(context, actionURL, this.clientWindow);
    }

    public ViewHandler getWrapped() {
        return this.wrapped;
    }

    private void lazyInit() {
        if (this.initialized == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.initialized == null) {
            this.securityAwareViewHandler = ClassDeactivationUtils.isActivated(((Object)((Object)this)).getClass()) ? this.createSecurityAwareViewHandler() : null;
            this.clientWindow = (ClientWindow)BeanProvider.getContextualReference(ClientWindow.class, (boolean)true, (Annotation[])new Annotation[0]);
            this.initialized = true;
        }
    }
}

