/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.deltaspike.data.impl.RepositoryExtension;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadata;
import org.apache.deltaspike.data.impl.meta.RepositoryMetadataInitializer;
import org.apache.deltaspike.data.impl.meta.RepositoryMethodMetadata;

@ApplicationScoped
public class RepositoryMetadataHandler {
    private final Map<Class<?>, RepositoryMetadata> repositoriesMetadata = new ConcurrentHashMap();
    @Inject
    private BeanManager beanManager;
    @Inject
    private RepositoryExtension extension;
    @Inject
    private RepositoryMetadataInitializer metadataInitializer;

    @PostConstruct
    public void init() {
        for (Class<?> repositoryClass : this.extension.getRepositoryClasses()) {
            RepositoryMetadata metadata = this.metadataInitializer.init(repositoryClass, this.beanManager);
            if (metadata == null) continue;
            this.repositoriesMetadata.put(repositoryClass, metadata);
        }
    }

    public RepositoryMetadata lookupMetadata(List<Class<?>> candidateClasses) {
        for (Class<?> repoClass : candidateClasses) {
            if (!this.repositoriesMetadata.containsKey(repoClass)) continue;
            return this.repositoriesMetadata.get(repoClass);
        }
        throw new RuntimeException("Unknown Repository classes " + candidateClasses);
    }

    public RepositoryMethodMetadata lookupMethodMetadata(RepositoryMetadata repositoryMetadata, Method method) {
        return repositoryMetadata.getMethodsMetadata().get(method);
    }
}

