/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.util;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Vetoed;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.PassivationCapable;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.apache.deltaspike.core.api.scope.ConversationGroup;
import org.apache.deltaspike.core.api.scope.ConversationSubGroup;
import org.apache.deltaspike.core.impl.scope.conversation.ConversationKey;

@Vetoed
public abstract class ConversationUtils {
    private ConversationUtils() {
    }

    public static ConversationKey convertToConversationKey(Contextual<?> contextual, BeanManager beanManager) {
        Bean bean;
        ConversationGroup conversationGroupAnnotation;
        if (!(contextual instanceof Bean)) {
            if (contextual instanceof PassivationCapable) {
                contextual = beanManager.getPassivationCapableBean(((PassivationCapable)contextual).getId());
            } else {
                throw new IllegalArgumentException(contextual.getClass().getName() + " is not of type " + Bean.class.getName());
            }
        }
        Class conversationGroup = (conversationGroupAnnotation = ConversationUtils.findConversationGroupAnnotation(bean = (Bean)contextual)) != null ? conversationGroupAnnotation.value() : bean.getBeanClass();
        Set qualifiers = bean.getQualifiers();
        return new ConversationKey(conversationGroup, qualifiers.toArray(new Annotation[qualifiers.size()]));
    }

    private static ConversationGroup findConversationGroupAnnotation(Bean<?> bean) {
        Set qualifiers = bean.getQualifiers();
        for (Annotation qualifier : qualifiers) {
            if (!ConversationGroup.class.isAssignableFrom(qualifier.annotationType())) continue;
            return (ConversationGroup)qualifier;
        }
        return null;
    }

    public static Class<?> getDeclaredConversationGroup(Class<?> conversationGroup) {
        ConversationSubGroup conversationSubGroup = conversationGroup.getAnnotation(ConversationSubGroup.class);
        if (conversationSubGroup == null) {
            return conversationGroup;
        }
        Class<?> result = conversationSubGroup.of();
        if (!ConversationSubGroup.class.equals((Object)result)) {
            return result;
        }
        result = conversationGroup.getSuperclass();
        if ((result == null || Object.class.getName().equals(result.getName())) && conversationGroup.getInterfaces().length == 1) {
            return conversationGroup.getInterfaces()[0];
        }
        if (result == null) {
            throw new IllegalStateException(conversationGroup.getName() + " hosts an invalid usage of @" + ConversationSubGroup.class.getName());
        }
        return result;
    }
}

