/*
 * Decompiled with CFR 0.152.
 */
package jdbm.htree;

import java.io.IOException;
import jdbm.RecordManager;
import jdbm.helper.FastIterator;
import jdbm.htree.HashDirectory;

public class HTree {
    private HashDirectory _root;

    private HTree(HashDirectory root) {
        this._root = root;
    }

    public static HTree createInstance(RecordManager recman) throws IOException {
        HashDirectory root = new HashDirectory(0);
        long recid = recman.insert(root);
        root.setPersistenceContext(recman, recid);
        return new HTree(root);
    }

    public static HTree load(RecordManager recman, long root_recid) throws IOException {
        HashDirectory root = (HashDirectory)recman.fetch(root_recid);
        root.setPersistenceContext(recman, root_recid);
        HTree tree = new HTree(root);
        return tree;
    }

    public synchronized void put(Object key, Object value) throws IOException {
        this._root.put(key, value);
    }

    public synchronized Object get(Object key) throws IOException {
        return this._root.get(key);
    }

    public synchronized void remove(Object key) throws IOException {
        this._root.remove(key);
    }

    public synchronized FastIterator keys() throws IOException {
        return this._root.keys();
    }

    public synchronized FastIterator values() throws IOException {
        return this._root.values();
    }

    public long getRecid() {
        return this._root.getRecid();
    }
}

