/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication.provider;

import java.io.File;
import java.util.Map;
import org.apache.directory.api.ldap.model.csn.Csn;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.ldap.replication.ReplicaEventMessage;
import org.apache.directory.server.ldap.replication.provider.ReplicaEventLog;
import org.apache.directory.server.ldap.replication.provider.ReplicaJournalCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaEventLogJanitor
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventLogJanitor.class);
    private DirectoryService directoryService;
    private Map<Integer, ReplicaEventLog> replicaLogMap;
    private volatile boolean stop = false;
    final Object lock = new Object();
    private long sleepTime = 300000L;
    private long thresholdTime = 0x6DDD00L;

    public ReplicaEventLogJanitor(DirectoryService directoryService, Map<Integer, ReplicaEventLog> replicaLogMap) {
        this.directoryService = directoryService;
        this.replicaLogMap = replicaLogMap;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            Object object = this.replicaLogMap.values().iterator();
            while (object.hasNext()) {
                ReplicaEventLog log;
                ReplicaEventLog replicaEventLog = log = object.next();
                synchronized (replicaEventLog) {
                    try {
                        ReplicaEventMessage message;
                        String csnVal;
                        String lastSentCsn = log.getLastSentCsn();
                        if (lastSentCsn == null) {
                            LOG.debug("last sent CSN is null for the replica {}, skipping cleanup", (Object)log.getName());
                            return;
                        }
                        long now = this.directoryService.getTimeProvider().currentIimeMillis();
                        long maxIdleTime = log.getMaxIdlePeriod() * 1000L;
                        long lastUpdatedTime = new Csn(lastSentCsn).getTimestamp();
                        LOG.debug("checking log idle time now={} lastUpdatedTime={} maxIdleTime={}", now, lastUpdatedTime, maxIdleTime);
                        if (maxIdleTime > 0L && now - lastUpdatedTime >= maxIdleTime) {
                            this.removeEventLog(log);
                            try {
                                this.directoryService.getAdminSession().delete(log.getConsumerEntryDn());
                            }
                            catch (LdapException e) {
                                LOG.warn("Failed to delete the entry {} of replica event log {}", log.getConsumerEntryDn(), log.getName(), e);
                            }
                            continue;
                        }
                        long thresholdCount = log.getPurgeThresholdCount();
                        if (log.count() < thresholdCount) {
                            continue;
                        }
                        LOG.debug("starting to purge the log entries that are older than {} milliseconds", (Object)this.thresholdTime);
                        long deleteCount = 0L;
                        ReplicaJournalCursor cursor = log.getCursor(null);
                        cursor.skipQualifyingWhileFetching();
                        while (cursor.next() && (csnVal = (message = cursor.get()).getEntry().get("entryCSN").getString()).compareTo(lastSentCsn) < 0) {
                            Csn csn = new Csn(csnVal);
                            if (now - csn.getTimestamp() < this.thresholdTime) continue;
                            cursor.delete();
                            ++deleteCount;
                        }
                        cursor.close();
                        LOG.debug("purged {} messages from the log {}", (Object)deleteCount, (Object)log.getName());
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to purge old entries from the log {}", (Object)log.getName(), (Object)e);
                    }
                }
            }
            try {
                object = this.lock;
                synchronized (object) {
                    this.lock.wait(this.sleepTime);
                }
            }
            catch (InterruptedException e) {
                LOG.warn("ReplicaEventLogJanitor thread was interrupted, processing logs for cleanup", e);
            }
        }
    }

    public synchronized void removeEventLog(ReplicaEventLog replicaEventLog) {
        this.directoryService.getEventService().removeListener(replicaEventLog.getPersistentListener());
        String name = replicaEventLog.getName();
        LOG.debug("removed the persistent listener for replication event log {}", (Object)name);
        this.replicaLogMap.remove(replicaEventLog.getId());
        try {
            replicaEventLog.stop();
            new File(this.directoryService.getInstanceLayout().getReplDirectory(), name + ".db").delete();
            new File(this.directoryService.getInstanceLayout().getReplDirectory(), name + ".lg").delete();
            LOG.info("successfully removed replication event log {}", (Object)name);
        }
        catch (Exception e) {
            LOG.warn("Closing the replication event log of the entry {} was not successful, will be removed anyway", (Object)name, (Object)e);
        }
    }

    public void setSleepTime(long sleepTime) {
        this.sleepTime = sleepTime;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCleaning() {
        this.stop = true;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }
}

