/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.config.beans;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.config.ConfigurationElement;
import org.apache.directory.server.config.beans.InterceptorBean;

public class HashInterceptorBean
extends InterceptorBean {
    @ConfigurationElement(attributeType="ads-hashAlgorithm", isOptional=true, defaultValue="SSHA-256")
    private String hashAlgorithm;
    @ConfigurationElement(attributeType="ads-hashAttribute", isOptional=true, defaultValues={"2.5.4.35"})
    private Set<String> hashAttributes = new HashSet<String>();

    public void addHashAttributes(String[] hashAttributes) {
        if (hashAttributes != null && hashAttributes.length > 0) {
            if (this.hashAttributes == null) {
                this.hashAttributes = new HashSet<String>();
            }
            this.hashAttributes.addAll(Arrays.asList(hashAttributes));
        }
    }

    public String getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public Set<String> getHashAttributes() {
        return this.hashAttributes;
    }

    public void setHashAlgorithm(String hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("HashInterceptor :\n");
        sb.append(super.toString(tabs + "  "));
        if (this.hashAlgorithm != null) {
            sb.append(tabs).append("  hashAlgorithm : ").append(this.hashAlgorithm).append("\n");
        }
        if (this.hashAttributes != null && !this.hashAttributes.isEmpty()) {
            sb.append(tabs).append("  hashAttributes :\n");
            for (String hashAttribute : this.hashAttributes) {
                sb.append(tabs).append("    ").append(hashAttribute);
            }
        }
        return sb.toString();
    }
}

