/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.entry;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.entryeditors.EntryEditorExtension;
import org.apache.directory.studio.entryeditors.EntryEditorInput;
import org.apache.directory.studio.entryeditors.EntryEditorManager;
import org.apache.directory.studio.entryeditors.EntryEditorUtils;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.entry.EntryEditor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;

public class EntryEditorNavigationLocation
extends NavigationLocation {
    EntryEditorNavigationLocation(EntryEditor editor) {
        super((IEditorPart)editor);
    }

    public String getText() {
        String text = EntryEditorUtils.getHistoryNavigationText(this.getEntryEditorInput());
        return text != null ? text : super.getText();
    }

    public void saveState(IMemento memento) {
        EntryEditorInput eei = this.getEntryEditorInput();
        if (eei != null) {
            memento.putString("EXTENSION", eei.getExtension().getId());
            if (eei.getEntryInput() != null) {
                IEntry entry = eei.getEntryInput();
                memento.putString("TYPE", "IEntry");
                memento.putString("Dn", entry.getDn().getName());
                memento.putString("CONNECTION", entry.getBrowserConnection().getConnection().getId());
            } else if (eei.getSearchResultInput() != null) {
                ISearchResult searchResult = eei.getSearchResultInput();
                memento.putString("TYPE", "ISearchResult");
                memento.putString("Dn", searchResult.getDn().getName());
                memento.putString("SEARCH", searchResult.getSearch().getName());
                memento.putString("CONNECTION", searchResult.getSearch().getBrowserConnection().getConnection().getId());
            } else if (eei.getBookmarkInput() != null) {
                IBookmark bookmark = eei.getBookmarkInput();
                memento.putString("TYPE", "IBookmark");
                memento.putString("BOOKMARK", bookmark.getName());
                memento.putString("CONNECTION", bookmark.getBrowserConnection().getConnection().getId());
            }
        }
    }

    public void restoreState(IMemento memento) {
        block7: {
            try {
                String type = memento.getString("TYPE");
                String extensionId = memento.getString("EXTENSION");
                EntryEditorManager entryEditorManager = BrowserUIPlugin.getDefault().getEntryEditorManager();
                EntryEditorExtension entryEditorExtension = entryEditorManager.getEntryEditorExtension(extensionId);
                if ("IEntry".equals(type)) {
                    IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
                    Dn dn = new Dn(new String[]{memento.getString("Dn")});
                    IEntry entry = connection.getEntryFromCache(dn);
                    super.setInput((Object)new EntryEditorInput(entry, entryEditorExtension));
                    break block7;
                }
                if ("ISearchResult".equals(type)) {
                    IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
                    ISearch search = connection.getSearchManager().getSearch(memento.getString("SEARCH"));
                    ISearchResult[] searchResults = search.getSearchResults();
                    Dn dn = new Dn(new String[]{memento.getString("Dn")});
                    int i = 0;
                    while (i < searchResults.length) {
                        if (dn.equals((Object)searchResults[i].getDn())) {
                            super.setInput((Object)new EntryEditorInput(searchResults[i], entryEditorExtension));
                            break block7;
                        }
                        ++i;
                    }
                    break block7;
                }
                if ("IBookmark".equals(type)) {
                    IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnectionById(memento.getString("CONNECTION"));
                    IBookmark bookmark = connection.getBookmarkManager().getBookmark(memento.getString("BOOKMARK"));
                    super.setInput((Object)new EntryEditorInput(bookmark, entryEditorExtension));
                }
            }
            catch (LdapInvalidDnException e) {
                e.printStackTrace();
            }
        }
    }

    public void restoreLocation() {
    }

    public boolean mergeInto(INavigationLocation currentLocation) {
        if (currentLocation == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != currentLocation.getClass()) {
            return false;
        }
        EntryEditorNavigationLocation location = (EntryEditorNavigationLocation)currentLocation;
        Object other = location.getEntryEditorInput().getInput();
        Object entry = this.getEntryEditorInput().getInput();
        if (other == null && entry == null) {
            return true;
        }
        if (other == null || entry == null) {
            return false;
        }
        return entry.equals(other);
    }

    public void update() {
    }

    private EntryEditorInput getEntryEditorInput() {
        Object editorInput = this.getInput();
        if (editorInput instanceof EntryEditorInput) {
            EntryEditorInput entryEditorInput = (EntryEditorInput)editorInput;
            return entryEditorInput;
        }
        return null;
    }

    public String toString() {
        return "" + this.getEntryEditorInput().getInput();
    }
}

