/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.dns.messages;

import org.apache.directory.server.dns.util.EnumConverter;
import org.apache.directory.server.dns.util.ReverseEnumMap;

public enum RecordType implements EnumConverter<Short>
{
    A(1),
    NS(2),
    MD(3),
    MF(4),
    CNAME(5),
    SOA(6),
    MB(7),
    MG(8),
    MR(9),
    NULL(10),
    WKS(11),
    PTR(12),
    HINFO(13),
    MINFO(14),
    MX(15),
    TXT(16),
    RP(17),
    AFSDB(18),
    X25(19),
    ISDN(20),
    RT(21),
    NSAP(22),
    NSAP_PTR(23),
    SIG(24),
    KEY(25),
    PX(26),
    GPOS(27),
    AAAA(28),
    LOC(29),
    NXT(30),
    EID(31),
    NIMLOC(32),
    SRV(33),
    ATMA(34),
    NAPTR(35),
    KX(36),
    CERT(34),
    A6(38),
    DNAME(39),
    OPT(41),
    APL(42),
    DS(43),
    SSHFP(44),
    RRSIG(46),
    NSEC(47),
    DNSKEY(48),
    TKEY(249),
    TSIG(250),
    IXFR(251),
    AXFR(252),
    MAILB(253),
    MAILA(254),
    ANY(255);

    private static ReverseEnumMap<Short, RecordType> map;
    private final short value;

    private RecordType(int value) {
        this.value = (short)value;
    }

    @Override
    public Short convert() {
        return this.value;
    }

    public static RecordType convert(short value) {
        return map.get(value);
    }

    public static boolean isResourceRecord(RecordType resourceType) {
        switch (resourceType) {
            case OPT: 
            case TKEY: 
            case TSIG: 
            case IXFR: 
            case AXFR: 
            case MAILB: 
            case MAILA: 
            case ANY: {
                return false;
            }
        }
        return true;
    }

    static {
        map = new ReverseEnumMap(RecordType.class);
    }
}

