/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.io.airlift.slice;

import com.facebook.presto.jdbc.internal.io.airlift.slice.FixedLengthSliceInput;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Preconditions;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Objects;

public final class BasicSliceInput
extends FixedLengthSliceInput {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BasicSliceInput.class).instanceSize();
    private final Slice slice;
    private int position;

    public BasicSliceInput(Slice slice) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
    }

    @Override
    public long length() {
        return this.slice.length();
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public void setPosition(long position) {
        Preconditions.checkPositionIndex(position, (long)this.slice.length());
        this.position = (int)position;
    }

    @Override
    public boolean isReadable() {
        return this.position < this.slice.length();
    }

    @Override
    public int available() {
        return this.slice.length() - this.position;
    }

    @Override
    public boolean readBoolean() {
        return this.readByte() != 0;
    }

    @Override
    public int read() {
        if (this.position >= this.slice.length()) {
            return -1;
        }
        int result = this.slice.getByte(this.position) & 0xFF;
        ++this.position;
        return result;
    }

    @Override
    public byte readByte() {
        int value = this.read();
        if (value == -1) {
            throw new IndexOutOfBoundsException();
        }
        return (byte)value;
    }

    @Override
    public int readUnsignedByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public short readShort() {
        short v = this.slice.getShort(this.position);
        this.position += 2;
        return v;
    }

    @Override
    public int readUnsignedShort() {
        return this.readShort() & 0xFFFF;
    }

    @Override
    public int readInt() {
        int v = this.slice.getInt(this.position);
        this.position += 4;
        return v;
    }

    @Override
    public long readLong() {
        long v = this.slice.getLong(this.position);
        this.position += 8;
        return v;
    }

    @Override
    public float readFloat() {
        float v = this.slice.getFloat(this.position);
        this.position += 4;
        return v;
    }

    @Override
    public double readDouble() {
        double v = this.slice.getDouble(this.position);
        this.position += 8;
        return v;
    }

    @Override
    public Slice readSlice(int length) {
        if (length == 0) {
            return Slices.EMPTY_SLICE;
        }
        Slice newSlice = this.slice.slice(this.position, length);
        this.position += length;
        return newSlice;
    }

    @Override
    public int read(byte[] destination, int destinationIndex, int length) {
        if (length == 0) {
            return 0;
        }
        if ((length = Math.min(length, this.available())) == 0) {
            return -1;
        }
        this.readBytes(destination, destinationIndex, length);
        return length;
    }

    @Override
    public void readBytes(byte[] destination, int destinationIndex, int length) {
        this.slice.getBytes(this.position, destination, destinationIndex, length);
        this.position += length;
    }

    @Override
    public void readBytes(Slice destination, int destinationIndex, int length) {
        this.slice.getBytes(this.position, destination, destinationIndex, length);
        this.position += length;
    }

    @Override
    public void readBytes(OutputStream out, int length) throws IOException {
        this.slice.getBytes(this.position, out, length);
        this.position += length;
    }

    @Override
    public long skip(long length) {
        length = Math.min(length, (long)this.available());
        this.position = (int)((long)this.position + length);
        return length;
    }

    @Override
    public int skipBytes(int length) {
        length = Math.min(length, this.available());
        this.position += length;
        return length;
    }

    @Override
    public long getRetainedSize() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    public Slice slice() {
        return this.slice.slice(this.position, this.slice.length() - this.position);
    }

    public String toString(Charset charset) {
        return this.slice.toString(this.position, this.available(), charset);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BasicSliceInput{");
        builder.append("position=").append(this.position);
        builder.append(", capacity=").append(this.slice.length());
        builder.append('}');
        return builder.toString();
    }
}

