/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.io.encoded;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.common.io.encoded.MemoryBuffer;

public class EncodedColumnBatch<BatchKey> {
    protected BatchKey batchKey;
    protected ColumnStreamData[][] columnData;
    protected int[] columnIxs;

    public void reset() {
        if (this.columnData == null) {
            return;
        }
        for (int i = 0; i < this.columnData.length; ++i) {
            if (this.columnData[i] == null) continue;
            for (int j = 0; j < this.columnData[i].length; ++j) {
                this.columnData[i][j] = null;
            }
        }
    }

    public void initColumn(int colIxMod, int colIx, int streamCount) {
        this.columnIxs[colIxMod] = colIx;
        if (this.columnData[colIxMod] == null || this.columnData[colIxMod].length != streamCount) {
            this.columnData[colIxMod] = new ColumnStreamData[streamCount];
        }
    }

    public void setStreamData(int colIxMod, int streamKind, ColumnStreamData csd) {
        this.columnData[colIxMod][streamKind] = csd;
    }

    public void setAllStreamsData(int colIxMod, int colIx, ColumnStreamData[] sbs) {
        this.columnIxs[colIxMod] = colIx;
        this.columnData[colIxMod] = sbs;
    }

    public BatchKey getBatchKey() {
        return this.batchKey;
    }

    public ColumnStreamData[][] getColumnData() {
        return this.columnData;
    }

    public int[] getColumnIxs() {
        return this.columnIxs;
    }

    protected void resetColumnArrays(int columnCount) {
        if (this.columnIxs != null && columnCount == this.columnIxs.length) {
            return;
        }
        this.columnIxs = new int[columnCount];
        ColumnStreamData[][] columnData = new ColumnStreamData[columnCount][];
        if (this.columnData != null) {
            for (int i = 0; i < Math.min(columnData.length, this.columnData.length); ++i) {
                columnData[i] = this.columnData[i];
            }
        }
        this.columnData = columnData;
    }

    public static class ColumnStreamData {
        private List<MemoryBuffer> cacheBuffers;
        private int indexBaseOffset = 0;
        private AtomicInteger refCount = new AtomicInteger(0);

        public void reset() {
            this.cacheBuffers.clear();
            this.refCount.set(0);
            this.indexBaseOffset = 0;
        }

        public void incRef() {
            this.refCount.incrementAndGet();
        }

        public int decRef() {
            int i = this.refCount.decrementAndGet();
            assert (i >= 0);
            return i;
        }

        public List<MemoryBuffer> getCacheBuffers() {
            return this.cacheBuffers;
        }

        public void setCacheBuffers(List<MemoryBuffer> cacheBuffers) {
            this.cacheBuffers = cacheBuffers;
        }

        public int getIndexBaseOffset() {
            return this.indexBaseOffset;
        }

        public void setIndexBaseOffset(int indexBaseOffset) {
            this.indexBaseOffset = indexBaseOffset;
        }
    }
}

