/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperConfiguration;
import org.apache.dolphinscheduler.plugin.registry.zookeeper.ZookeeperConnectionStateListener;
import org.apache.dolphinscheduler.registry.api.ConnectionListener;
import org.apache.dolphinscheduler.registry.api.Event;
import org.apache.dolphinscheduler.registry.api.Registry;
import org.apache.dolphinscheduler.registry.api.RegistryException;
import org.apache.dolphinscheduler.registry.api.SubscribeListener;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;

public final class ZookeeperRegistry
implements Registry {
    private CuratorFramework client;
    private final Map<String, TreeCache> treeCacheMap = new ConcurrentHashMap<String, TreeCache>();
    private static final ThreadLocal<Map<String, InterProcessMutex>> threadLocalLockMap = new ThreadLocal();

    private static RetryPolicy buildRetryPolicy(Map<String, String> registerData) {
        int baseSleepTimeMs = (Integer)ZookeeperConfiguration.BASE_SLEEP_TIME.getParameterValue(registerData.get(ZookeeperConfiguration.BASE_SLEEP_TIME.getName()));
        int maxRetries = (Integer)ZookeeperConfiguration.MAX_RETRIES.getParameterValue(registerData.get(ZookeeperConfiguration.MAX_RETRIES.getName()));
        int maxSleepMs = baseSleepTimeMs * maxRetries;
        return new ExponentialBackoffRetry(baseSleepTimeMs, maxRetries, maxSleepMs);
    }

    private static void buildDigest(CuratorFrameworkFactory.Builder builder, String digest) {
        builder.authorization(ZookeeperConfiguration.DIGEST.getName(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

            public List<ACL> getDefaultAcl() {
                return ZooDefs.Ids.CREATOR_ALL_ACL;
            }

            public List<ACL> getAclForPath(String path) {
                return ZooDefs.Ids.CREATOR_ALL_ACL;
            }
        });
    }

    public void start(Map<String, String> config) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().connectString((String)ZookeeperConfiguration.SERVERS.getParameterValue(config.get(ZookeeperConfiguration.SERVERS.getName()))).retryPolicy(ZookeeperRegistry.buildRetryPolicy(config)).namespace((String)ZookeeperConfiguration.NAME_SPACE.getParameterValue(config.get(ZookeeperConfiguration.NAME_SPACE.getName()))).sessionTimeoutMs(((Integer)ZookeeperConfiguration.SESSION_TIMEOUT_MS.getParameterValue(config.get(ZookeeperConfiguration.SESSION_TIMEOUT_MS.getName()))).intValue()).connectionTimeoutMs(((Integer)ZookeeperConfiguration.CONNECTION_TIMEOUT_MS.getParameterValue(config.get(ZookeeperConfiguration.CONNECTION_TIMEOUT_MS.getName()))).intValue());
        String digest = (String)ZookeeperConfiguration.DIGEST.getParameterValue(config.get(ZookeeperConfiguration.DIGEST.getName()));
        if (!Strings.isNullOrEmpty((String)digest)) {
            ZookeeperRegistry.buildDigest(builder, digest);
        }
        this.client = builder.build();
        this.client.start();
        try {
            if (!this.client.blockUntilConnected(((Integer)ZookeeperConfiguration.BLOCK_UNTIL_CONNECTED_WAIT_MS.getParameterValue(config.get(ZookeeperConfiguration.BLOCK_UNTIL_CONNECTED_WAIT_MS.getName()))).intValue(), TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new RegistryException("zookeeper connect timeout");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RegistryException("zookeeper connect error", (Throwable)e);
        }
    }

    public void addConnectionStateListener(ConnectionListener listener) {
        this.client.getConnectionStateListenable().addListener((Object)new ZookeeperConnectionStateListener(listener));
    }

    public boolean subscribe(String path, SubscribeListener listener) {
        TreeCache treeCache = this.treeCacheMap.computeIfAbsent(path, $ -> new TreeCache(this.client, path));
        treeCache.getListenable().addListener(($, event) -> listener.notify((Event)new EventAdaptor(event, path)));
        try {
            treeCache.start();
        }
        catch (Exception e) {
            this.treeCacheMap.remove(path);
            throw new RegistryException("Failed to subscribe listener for key: " + path, (Throwable)e);
        }
        return true;
    }

    public void unsubscribe(String path) {
        CloseableUtils.closeQuietly((Closeable)((Closeable)this.treeCacheMap.get(path)));
    }

    public String get(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get data error", (Throwable)e);
        }
    }

    public boolean exists(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper check key is existed error", (Throwable)e);
        }
    }

    public void put(String key, String value, boolean deleteOnDisconnect) {
        CreateMode mode = deleteOnDisconnect ? CreateMode.EPHEMERAL : CreateMode.PERSISTENT;
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().orSetData().creatingParentsIfNeeded().withMode(mode)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new RegistryException("Failed to put registry key: " + key, (Throwable)e);
        }
    }

    public List<String> children(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper get children error", (Throwable)e);
        }
    }

    public void delete(String nodePath) {
        try {
            this.client.delete().deletingChildrenIfNeeded().forPath(nodePath);
        }
        catch (KeeperException.NoNodeException noNodeException) {
        }
        catch (Exception e) {
            throw new RegistryException("Failed to delete registry key: " + nodePath, (Throwable)e);
        }
    }

    public boolean acquireLock(String key) {
        InterProcessMutex interProcessMutex = new InterProcessMutex(this.client, key);
        try {
            interProcessMutex.acquire();
            if (null == threadLocalLockMap.get()) {
                threadLocalLockMap.set(new HashMap(3));
            }
            threadLocalLockMap.get().put(key, interProcessMutex);
            return true;
        }
        catch (Exception e) {
            try {
                interProcessMutex.release();
                throw new RegistryException("zookeeper get lock error", (Throwable)e);
            }
            catch (Exception exception) {
                throw new RegistryException("zookeeper release lock error", (Throwable)e);
            }
        }
    }

    public boolean releaseLock(String key) {
        if (null == threadLocalLockMap.get().get(key)) {
            return false;
        }
        try {
            threadLocalLockMap.get().get(key).release();
            threadLocalLockMap.get().remove(key);
            if (threadLocalLockMap.get().isEmpty()) {
                threadLocalLockMap.remove();
            }
        }
        catch (Exception e) {
            throw new RegistryException("zookeeper release lock error", (Throwable)e);
        }
        return true;
    }

    public void close() {
        this.treeCacheMap.values().forEach(CloseableUtils::closeQuietly);
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    static final class EventAdaptor
    extends Event {
        public EventAdaptor(TreeCacheEvent event, String key) {
            this.key(key);
            switch (event.getType()) {
                case NODE_ADDED: {
                    this.type(Event.Type.ADD);
                    break;
                }
                case NODE_UPDATED: {
                    this.type(Event.Type.UPDATE);
                    break;
                }
                case NODE_REMOVED: {
                    this.type(Event.Type.REMOVE);
                    break;
                }
            }
            ChildData data = event.getData();
            if (data != null) {
                this.path(data.getPath());
                this.data(new String(data.getData()));
            }
        }
    }
}

