/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.enums.Flag;
import org.apache.dolphinscheduler.common.enums.Priority;
import org.apache.dolphinscheduler.common.enums.TaskType;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchParameters;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.ProcessDefinition;
import org.apache.dolphinscheduler.dao.entity.ProcessInstance;
import org.apache.dolphinscheduler.dao.entity.TaskDefinition;

@TableName(value="t_ds_task_instance")
public class TaskInstance
implements Serializable {
    @TableId(value="id", type=IdType.AUTO)
    private int id;
    private String name;
    private String taskType;
    private int processInstanceId;
    private long taskCode;
    private int taskDefinitionVersion;
    @TableField(exist=false)
    private String processInstanceName;
    private ExecutionStatus state;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date firstSubmitTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date submitTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date startTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date endTime;
    private String host;
    private String executePath;
    private String logPath;
    private int retryTimes;
    private Flag alertFlag;
    @TableField(exist=false)
    private ProcessInstance processInstance;
    @TableField(exist=false)
    private ProcessDefinition processDefine;
    @TableField(exist=false)
    private TaskDefinition taskDefine;
    private int pid;
    private String appLink;
    private Flag flag;
    @TableField(exist=false)
    private DependentParameters dependency;
    @TableField(exist=false)
    private SwitchParameters switchDependency;
    @TableField(exist=false)
    private String duration;
    private int maxRetryTimes;
    private int retryInterval;
    private Priority taskInstancePriority;
    @TableField(exist=false)
    private Priority processInstancePriority;
    @TableField(exist=false)
    private String dependentResult;
    private String workerGroup;
    private Long environmentCode;
    private String environmentConfig;
    private int executorId;
    private String varPool;
    @TableField(exist=false)
    private String executorName;
    @TableField(exist=false)
    private Map<String, String> resources;
    private int delayTime;
    private String taskParams;
    private int dryRun;

    public void init(String host, Date startTime, String executePath) {
        this.host = host;
        this.startTime = startTime;
        this.executePath = executePath;
    }

    public String getVarPool() {
        return this.varPool;
    }

    public void setVarPool(String varPool) {
        this.varPool = varPool;
    }

    public ProcessInstance getProcessInstance() {
        return this.processInstance;
    }

    public void setProcessInstance(ProcessInstance processInstance) {
        this.processInstance = processInstance;
    }

    public ProcessDefinition getProcessDefine() {
        return this.processDefine;
    }

    public void setProcessDefine(ProcessDefinition processDefine) {
        this.processDefine = processDefine;
    }

    public TaskDefinition getTaskDefine() {
        return this.taskDefine;
    }

    public void setTaskDefine(TaskDefinition taskDefine) {
        this.taskDefine = taskDefine;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTaskType() {
        return this.taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public int getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(int processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public ExecutionStatus getState() {
        return this.state;
    }

    public void setState(ExecutionStatus state) {
        this.state = state;
    }

    public Date getFirstSubmitTime() {
        return this.firstSubmitTime;
    }

    public void setFirstSubmitTime(Date firstSubmitTime) {
        this.firstSubmitTime = firstSubmitTime;
    }

    public Date getSubmitTime() {
        return this.submitTime;
    }

    public void setSubmitTime(Date submitTime) {
        this.submitTime = submitTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getExecutePath() {
        return this.executePath;
    }

    public void setExecutePath(String executePath) {
        this.executePath = executePath;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public Flag getAlertFlag() {
        return this.alertFlag;
    }

    public void setAlertFlag(Flag alertFlag) {
        this.alertFlag = alertFlag;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public Boolean isTaskSuccess() {
        return this.state == ExecutionStatus.SUCCESS;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPid(int pid) {
        this.pid = pid;
    }

    public String getAppLink() {
        return this.appLink;
    }

    public void setAppLink(String appLink) {
        this.appLink = appLink;
    }

    public Long getEnvironmentCode() {
        return this.environmentCode;
    }

    public void setEnvironmentCode(Long environmentCode) {
        this.environmentCode = environmentCode;
    }

    public String getEnvironmentConfig() {
        return this.environmentConfig;
    }

    public void setEnvironmentConfig(String environmentConfig) {
        this.environmentConfig = environmentConfig;
    }

    public DependentParameters getDependency() {
        if (this.dependency == null) {
            Map taskParamsMap = (Map)JSONUtils.parseObject((String)this.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.dependency = (DependentParameters)JSONUtils.parseObject((String)((String)taskParamsMap.get("dependence")), DependentParameters.class);
        }
        return this.dependency;
    }

    public void setDependency(DependentParameters dependency) {
        this.dependency = dependency;
    }

    public SwitchParameters getSwitchDependency() {
        if (this.switchDependency == null) {
            Map taskParamsMap = (Map)JSONUtils.parseObject((String)this.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
            this.switchDependency = (SwitchParameters)JSONUtils.parseObject((String)((String)taskParamsMap.get("switchResult")), SwitchParameters.class);
        }
        return this.switchDependency;
    }

    public void setSwitchDependency(SwitchParameters switchDependency) {
        Map taskParamsMap = (Map)JSONUtils.parseObject((String)this.getTaskParams(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        taskParamsMap.put("switchResult", JSONUtils.toJsonString((Object)switchDependency));
        this.setTaskParams(JSONUtils.toJsonString((Object)taskParamsMap));
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public String getProcessInstanceName() {
        return this.processInstanceName;
    }

    public void setProcessInstanceName(String processInstanceName) {
        this.processInstanceName = processInstanceName;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public int getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    public int getExecutorId() {
        return this.executorId;
    }

    public void setExecutorId(int executorId) {
        this.executorId = executorId;
    }

    public String getExecutorName() {
        return this.executorName;
    }

    public void setExecutorName(String executorName) {
        this.executorName = executorName;
    }

    public int getDryRun() {
        return this.dryRun;
    }

    public void setDryRun(int dryRun) {
        this.dryRun = dryRun;
    }

    public boolean isTaskComplete() {
        return this.getState().typeIsSuccess() || this.getState().typeIsCancel() || this.getState().typeIsFailure() && !this.taskCanRetry();
    }

    public Map<String, String> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, String> resources) {
        this.resources = resources;
    }

    public boolean isSubProcess() {
        return TaskType.SUB_PROCESS.getDesc().equalsIgnoreCase(this.taskType);
    }

    public boolean isDependTask() {
        return TaskType.DEPENDENT.getDesc().equalsIgnoreCase(this.taskType);
    }

    public boolean isConditionsTask() {
        return TaskType.CONDITIONS.getDesc().equalsIgnoreCase(this.taskType);
    }

    public boolean isSwitchTask() {
        return TaskType.SWITCH.getDesc().equalsIgnoreCase(this.taskType);
    }

    public boolean taskCanRetry() {
        if (this.isSubProcess()) {
            return false;
        }
        if (this.getState() == ExecutionStatus.NEED_FAULT_TOLERANCE) {
            return true;
        }
        return this.getState().typeIsFailure() && this.getRetryTimes() <= this.getMaxRetryTimes();
    }

    public boolean retryTaskIntervalOverTime() {
        if (this.getState() != ExecutionStatus.FAILURE) {
            return false;
        }
        if (this.getId() == 0 || this.getMaxRetryTimes() == 0 || this.getRetryInterval() == 0) {
            return false;
        }
        Date now = new Date();
        long failedTimeInterval = DateUtils.differSec((Date)now, (Date)this.getEndTime());
        return (long)(this.getRetryInterval() * 60) < failedTimeInterval;
    }

    public Priority getTaskInstancePriority() {
        return this.taskInstancePriority;
    }

    public void setTaskInstancePriority(Priority taskInstancePriority) {
        this.taskInstancePriority = taskInstancePriority;
    }

    public Priority getProcessInstancePriority() {
        return this.processInstancePriority;
    }

    public void setProcessInstancePriority(Priority processInstancePriority) {
        this.processInstancePriority = processInstancePriority;
    }

    public String getWorkerGroup() {
        return this.workerGroup;
    }

    public void setWorkerGroup(String workerGroup) {
        this.workerGroup = workerGroup;
    }

    public String getDependentResult() {
        return this.dependentResult;
    }

    public void setDependentResult(String dependentResult) {
        this.dependentResult = dependentResult;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public String toString() {
        return "TaskInstance{id=" + this.id + ", name='" + this.name + '\'' + ", taskType='" + this.taskType + '\'' + ", processInstanceId=" + this.processInstanceId + ", processInstanceName='" + this.processInstanceName + '\'' + ", state=" + this.state + ", firstSubmitTime=" + this.firstSubmitTime + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", host='" + this.host + '\'' + ", executePath='" + this.executePath + '\'' + ", logPath='" + this.logPath + '\'' + ", retryTimes=" + this.retryTimes + ", alertFlag=" + this.alertFlag + ", processInstance=" + this.processInstance + ", processDefine=" + this.processDefine + ", pid=" + this.pid + ", appLink='" + this.appLink + '\'' + ", flag=" + this.flag + ", dependency='" + this.dependency + '\'' + ", duration=" + this.duration + ", maxRetryTimes=" + this.maxRetryTimes + ", retryInterval=" + this.retryInterval + ", taskInstancePriority=" + this.taskInstancePriority + ", processInstancePriority=" + this.processInstancePriority + ", dependentResult='" + this.dependentResult + '\'' + ", workerGroup='" + this.workerGroup + '\'' + ", environmentCode=" + this.environmentCode + ", environmentConfig='" + this.environmentConfig + '\'' + ", executorId=" + this.executorId + ", executorName='" + this.executorName + '\'' + ", delayTime=" + this.delayTime + ", dryRun=" + this.dryRun + '}';
    }

    public long getTaskCode() {
        return this.taskCode;
    }

    public void setTaskCode(long taskCode) {
        this.taskCode = taskCode;
    }

    public int getTaskDefinitionVersion() {
        return this.taskDefinitionVersion;
    }

    public void setTaskDefinitionVersion(int taskDefinitionVersion) {
        this.taskDefinitionVersion = taskDefinitionVersion;
    }

    public String getTaskParams() {
        return this.taskParams;
    }

    public void setTaskParams(String taskParams) {
        this.taskParams = taskParams;
    }

    public boolean isFirstRun() {
        return this.endTime == null;
    }
}

