/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class CollectionUtils {
    private CollectionUtils() {
        throw new UnsupportedOperationException("Construct CollectionUtils");
    }

    public static boolean equalLists(Collection<?> a, Collection<?> b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return CollectionUtils.isEqualCollection(a, b);
    }

    public static boolean isEqualCollection(Collection<?> a, Collection<?> b) {
        if (a.size() != b.size()) {
            return false;
        }
        CardinalityHelper helper = new CardinalityHelper(a, b);
        if (helper.cardinalityA.size() != helper.cardinalityB.size()) {
            return false;
        }
        for (Object obj : helper.cardinalityA.keySet()) {
            if (helper.freqA(obj) == helper.freqB(obj)) continue;
            return false;
        }
        return true;
    }

    public static <O> Map<O, Integer> getCardinalityMap(Iterable<? extends O> coll) {
        HashMap<O, Integer> count = new HashMap<O, Integer>();
        for (O obj : coll) {
            count.put(obj, count.getOrDefault(obj, 0) + 1);
        }
        return count;
    }

    private static class CardinalityHelper<O> {
        final Map<O, Integer> cardinalityA;
        final Map<O, Integer> cardinalityB;

        public CardinalityHelper(Iterable<? extends O> a, Iterable<? extends O> b) {
            this.cardinalityA = CollectionUtils.getCardinalityMap(a);
            this.cardinalityB = CollectionUtils.getCardinalityMap(b);
        }

        public int freqA(Object obj) {
            return this.getFreq(obj, this.cardinalityA);
        }

        public int freqB(Object obj) {
            return this.getFreq(obj, this.cardinalityB);
        }

        private int getFreq(Object obj, Map<?, Integer> freqMap) {
            Integer count = freqMap.get(obj);
            if (count != null) {
                return count;
            }
            return 0;
        }
    }
}

