/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import org.apache.dolphinscheduler.api.aspect.AccessLogAnnotation;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.TaskInstanceService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.common.enums.ExecutionStatus;
import org.apache.dolphinscheduler.common.utils.ParameterUtils;
import org.apache.dolphinscheduler.dao.entity.User;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@Api(tags={"TASK_INSTANCE_TAG"})
@RestController
@RequestMapping(value={"/projects/{projectCode}/task-instances"})
public class TaskInstanceController
extends BaseController {
    @Autowired
    TaskInstanceService taskInstanceService;

    @ApiOperation(value="queryTaskListPaging", notes="QUERY_TASK_INSTANCE_LIST_PAGING_NOTES")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="PROCESS_INSTANCE_ID", required=false, dataType="Int", example="100"), @ApiImplicitParam(name="processInstanceName", value="PROCESS_INSTANCE_NAME", required=false, type="String"), @ApiImplicitParam(name="searchVal", value="SEARCH_VAL", type="String"), @ApiImplicitParam(name="taskName", value="TASK_NAME", type="String"), @ApiImplicitParam(name="executorName", value="EXECUTOR_NAME", type="String"), @ApiImplicitParam(name="stateType", value="EXECUTION_STATUS", type="ExecutionStatus"), @ApiImplicitParam(name="host", value="HOST", type="String"), @ApiImplicitParam(name="startDate", value="START_DATE", type="String"), @ApiImplicitParam(name="endDate", value="END_DATE", type="String"), @ApiImplicitParam(name="pageNo", value="PAGE_NO", required=true, dataType="Int", example="1"), @ApiImplicitParam(name="pageSize", value="PAGE_SIZE", required=true, dataType="Int", example="20")})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_TASK_LIST_PAGING_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result queryTaskListPaging(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @RequestParam(value="processInstanceId", required=false, defaultValue="0") Integer processInstanceId, @RequestParam(value="processInstanceName", required=false) String processInstanceName, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="taskName", required=false) String taskName, @RequestParam(value="executorName", required=false) String executorName, @RequestParam(value="stateType", required=false) ExecutionStatus stateType, @RequestParam(value="host", required=false) String host, @RequestParam(value="startDate", required=false) String startTime, @RequestParam(value="endDate", required=false) String endTime, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        Result result = this.checkPageParams(pageNo, pageSize);
        if (!result.checkResult().booleanValue()) {
            return result;
        }
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        result = this.taskInstanceService.queryTaskListPaging(loginUser, projectCode, processInstanceId, processInstanceName, taskName, executorName, startTime, endTime, searchVal, stateType, host, pageNo, pageSize);
        return result;
    }

    @ApiOperation(value="force-success", notes="FORCE_TASK_SUCCESS")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="TASK_INSTANCE_ID", required=true, dataType="Int", example="12")})
    @PostMapping(value={"/{id}/force-success"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.FORCE_TASK_SUCCESS_ERROR)
    @AccessLogAnnotation(ignoreRequestArgs={"loginUser"})
    public Result<Object> forceTaskSuccess(@ApiIgnore @RequestAttribute(value="session.user") User loginUser, @ApiParam(name="projectCode", value="PROJECT_CODE", required=true) @PathVariable long projectCode, @PathVariable(value="id") Integer id) {
        Map<String, Object> result = this.taskInstanceService.forceTaskSuccess(loginUser, projectCode, id);
        return this.returnDataList(result);
    }
}

