/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    private static final Logger logger = LoggerFactory.getLogger(FileUtils.class);

    public static void copyInputStreamToFile(MultipartFile file, String destFilename) {
        try {
            org.apache.commons.io.FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)new File(destFilename));
        }
        catch (IOException e) {
            logger.error("failed to copy file , {} is empty file", (Object)file.getOriginalFilename(), (Object)e);
        }
    }

    public static Resource file2Resource(String filename) throws MalformedURLException {
        Path file = Paths.get(filename, new String[0]);
        UrlResource resource = new UrlResource(file.toUri());
        if (resource.exists() || resource.isReadable()) {
            return resource;
        }
        logger.error("file can not read : {}", (Object)filename);
        return null;
    }

    public static String file2String(MultipartFile file) {
        try {
            return IOUtils.toString((InputStream)file.getInputStream(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            logger.error("file convert to string failed: {}", (Object)file.getName());
            return "";
        }
    }
}

