/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.runner.task;

import com.google.common.base.Strings;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessFactory;
import org.apache.dolphinscheduler.server.master.runner.task.ITaskProcessor;

public class TaskProcessorFactory {
    public static final Map<String, ITaskProcessFactory> PROCESS_FACTORY_MAP = new ConcurrentHashMap<String, ITaskProcessFactory>();
    private static final String DEFAULT_PROCESSOR = "common";

    public static ITaskProcessor getTaskProcessor(String type) {
        if (Strings.isNullOrEmpty((String)type)) {
            return PROCESS_FACTORY_MAP.get(DEFAULT_PROCESSOR).create();
        }
        if (!PROCESS_FACTORY_MAP.containsKey(type)) {
            return PROCESS_FACTORY_MAP.get(DEFAULT_PROCESSOR).create();
        }
        return PROCESS_FACTORY_MAP.get(type).create();
    }

    static {
        for (ITaskProcessFactory iTaskProcessor : ServiceLoader.load(ITaskProcessFactory.class)) {
            PROCESS_FACTORY_MAP.put(iTaskProcessor.type(), iTaskProcessor);
        }
    }
}

