/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.rpc.future;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.dolphinscheduler.rpc.common.RpcRequest;
import org.apache.dolphinscheduler.rpc.common.RpcResponse;

public class RpcFuture
implements Future<Object> {
    private CountDownLatch latch = new CountDownLatch(1);
    private RpcResponse response;
    private RpcRequest request;
    private long requestId;

    public RpcFuture(RpcRequest rpcRequest, long requestId) {
        this.request = rpcRequest;
        this.requestId = requestId;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public RpcResponse get() throws InterruptedException {
        boolean success = this.latch.await(5L, TimeUnit.SECONDS);
        if (!success) {
            throw new RuntimeException("Timeout exception. Request id: " + this.requestId + ". Request class name: " + this.request.getClassName() + ". Request method: " + this.request.getMethodName());
        }
        return this.response;
    }

    @Override
    public RpcResponse get(long timeout, TimeUnit unit) throws InterruptedException {
        boolean success = this.latch.await(timeout, unit);
        if (!success) {
            throw new RuntimeException("Timeout exception. Request id: " + this.requestId + ". Request class name: " + this.request.getClassName() + ". Request method: " + this.request.getMethodName());
        }
        return this.response;
    }

    public void done(RpcResponse response) {
        this.response = response;
        this.latch.countDown();
    }
}

