/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import java.io.Closeable;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.apache.dolphinscheduler.alert.AlertPluginManager;
import org.apache.dolphinscheduler.alert.AlertRequestProcessor;
import org.apache.dolphinscheduler.alert.AlertSender;
import org.apache.dolphinscheduler.common.thread.Stopper;
import org.apache.dolphinscheduler.dao.AlertDao;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.remote.NettyRemotingServer;
import org.apache.dolphinscheduler.remote.command.CommandType;
import org.apache.dolphinscheduler.remote.config.NettyServerConfig;
import org.apache.dolphinscheduler.remote.processor.NettyRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.EventListener;

@EnableAutoConfiguration
@ComponentScan(value={"org.apache.dolphinscheduler.alert", "org.apache.dolphinscheduler.dao"})
public class AlertServer
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AlertServer.class);
    private final PluginDao pluginDao;
    private final AlertDao alertDao;
    private final AlertPluginManager alertPluginManager;
    private final AlertSender alertSender;
    private final AlertRequestProcessor alertRequestProcessor;
    private NettyRemotingServer server;

    public AlertServer(PluginDao pluginDao, AlertDao alertDao, AlertPluginManager alertPluginManager, AlertSender alertSender, AlertRequestProcessor alertRequestProcessor) {
        this.pluginDao = pluginDao;
        this.alertDao = alertDao;
        this.alertPluginManager = alertPluginManager;
        this.alertSender = alertSender;
        this.alertRequestProcessor = alertRequestProcessor;
    }

    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{AlertServer.class}).web(WebApplicationType.NONE).run(args);
    }

    @EventListener
    public void start(ApplicationReadyEvent readyEvent) {
        log.info("Starting Alert server");
        this.checkTable();
        this.startServer();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Sender(), 5L, 5L, TimeUnit.SECONDS);
    }

    @Override
    @PreDestroy
    public void close() {
        this.server.close();
    }

    private void checkTable() {
        if (!this.pluginDao.checkPluginDefineTableExist()) {
            log.error("Plugin Define Table t_ds_plugin_define Not Exist . Please Create it First !");
            System.exit(1);
        }
    }

    private void startServer() {
        NettyServerConfig serverConfig = new NettyServerConfig();
        serverConfig.setListenPort(50052);
        this.server = new NettyRemotingServer(serverConfig);
        this.server.registerProcessor(CommandType.ALERT_SEND_REQUEST, (NettyRequestProcessor)this.alertRequestProcessor);
        this.server.start();
    }

    final class Sender
    implements Runnable {
        Sender() {
        }

        @Override
        public void run() {
            if (!Stopper.isRunning()) {
                return;
            }
            try {
                List alerts = AlertServer.this.alertDao.listPendingAlerts();
                AlertServer.this.alertSender.send(alerts);
            }
            catch (Exception e) {
                log.error("Failed to send alert", (Throwable)e);
            }
        }
    }
}

