/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.mybatisplus.core;

import com.baomidou.mybatisplus.core.MybatisMapperRegistry;
import com.baomidou.mybatisplus.core.MybatisXMLLanguageDriver;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.executor.AbstractBaseExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisBatchExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisReuseExecutor;
import com.baomidou.mybatisplus.core.executor.MybatisSimpleExecutor;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import org.apache.ibatis.binding.MapperRegistry;
import org.apache.ibatis.executor.CachingExecutor;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.transaction.Transaction;

public class MybatisConfiguration
extends Configuration {
    private static final Log logger = LogFactory.getLog(MybatisConfiguration.class);
    protected final MybatisMapperRegistry mybatisMapperRegistry = new MybatisMapperRegistry(this);
    private GlobalConfig globalConfig = GlobalConfigUtils.defaults();

    public MybatisConfiguration(Environment environment) {
        this();
        this.environment = environment;
    }

    public MybatisConfiguration() {
        this.mapUnderscoreToCamelCase = true;
        this.languageRegistry.setDefaultDriverClass(MybatisXMLLanguageDriver.class);
    }

    public void addMappedStatement(MappedStatement ms) {
        logger.debug("addMappedStatement: " + ms.getId());
        if (this.mappedStatements.containsKey(ms.getId())) {
            logger.error("mapper[" + ms.getId() + "] is ignored, because it exists, maybe from xml file");
            return;
        }
        super.addMappedStatement(ms);
    }

    public MapperRegistry getMapperRegistry() {
        return this.mybatisMapperRegistry;
    }

    public <T> void addMapper(Class<T> type) {
        this.mybatisMapperRegistry.addMapper(type);
    }

    public void addMappers(String packageName, Class<?> superType) {
        this.mybatisMapperRegistry.addMappers(packageName, superType);
    }

    public void addMappers(String packageName) {
        this.mybatisMapperRegistry.addMappers(packageName);
    }

    public <T> T getMapper(Class<T> type, SqlSession sqlSession) {
        return this.mybatisMapperRegistry.getMapper(type, sqlSession);
    }

    public boolean hasMapper(Class<?> type) {
        return this.mybatisMapperRegistry.hasMapper(type);
    }

    public void setDefaultScriptingLanguage(Class<? extends LanguageDriver> driver) {
        if (driver == null) {
            driver = MybatisXMLLanguageDriver.class;
        }
        this.getLanguageRegistry().setDefaultDriverClass(driver);
    }

    public Executor newExecutor(Transaction transaction, ExecutorType executorType) {
        executorType = executorType == null ? this.defaultExecutorType : executorType;
        ExecutorType executorType2 = executorType = executorType == null ? ExecutorType.SIMPLE : executorType;
        AbstractBaseExecutor executor = ExecutorType.BATCH == executorType ? new MybatisBatchExecutor(this, transaction) : (ExecutorType.REUSE == executorType ? new MybatisReuseExecutor(this, transaction) : new MybatisSimpleExecutor(this, transaction));
        if (this.cacheEnabled) {
            executor = new CachingExecutor((Executor)executor);
        }
        executor = (Executor)this.interceptorChain.pluginAll((Object)executor);
        return executor;
    }

    public void setGlobalConfig(GlobalConfig globalConfig) {
        this.globalConfig = globalConfig;
    }

    public GlobalConfig getGlobalConfig() {
        return this.globalConfig;
    }
}

