/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.dolphinscheduler.common.shell.ShellExecutor;
import org.apache.dolphinscheduler.common.utils.CommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

public class OSUtils {
    private static final Logger logger = LoggerFactory.getLogger(OSUtils.class);
    private static final SystemInfo SI = new SystemInfo();
    public static final String TWO_DECIMAL = "0.00";
    public static final double NEGATIVE_ONE = -1.0;
    private static final HardwareAbstractionLayer hal = SI.getHardware();
    private static long[] prevTicks = new long[CentralProcessor.TickType.values().length];
    private static long prevTickTime = 0L;
    private static double cpuUsage = 0.0;
    private static final Pattern PATTERN = Pattern.compile("\\s+");

    private OSUtils() {
        throw new UnsupportedOperationException("Construct OSUtils");
    }

    public static double memoryUsage() {
        GlobalMemory memory = hal.getMemory();
        double memoryUsage = (double)(memory.getTotal() - memory.getAvailable()) * 1.0 / (double)memory.getTotal();
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(memoryUsage));
    }

    public static double diskAvailable() {
        File file = new File(".");
        long totalSpace = file.getTotalSpace();
        long freeSpace = file.getFreeSpace();
        double diskAvailable = (double)freeSpace / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(diskAvailable));
    }

    public static double availablePhysicalMemorySize() {
        GlobalMemory memory = hal.getMemory();
        double availablePhysicalMemorySize = (double)memory.getAvailable() / 1024.0 / 1024.0 / 1024.0;
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(availablePhysicalMemorySize));
    }

    public static double loadAverage() {
        double loadAverage;
        block2: {
            try {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                loadAverage = osBean.getSystemLoadAverage();
            }
            catch (Exception e) {
                logger.error("get operation system load average exception, try another method ", (Throwable)e);
                loadAverage = hal.getProcessor().getSystemLoadAverage(1)[0];
                if (!Double.isNaN(loadAverage)) break block2;
                return -1.0;
            }
        }
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(loadAverage));
    }

    public static double cpuUsage() {
        CentralProcessor processor = hal.getProcessor();
        long now = System.currentTimeMillis();
        if (now - prevTickTime > 950L) {
            cpuUsage = processor.getSystemCpuLoadBetweenTicks(prevTicks);
            prevTickTime = System.currentTimeMillis();
            prevTicks = processor.getSystemCpuLoadTicks();
        }
        if (Double.isNaN(cpuUsage)) {
            return -1.0;
        }
        DecimalFormat df = new DecimalFormat(TWO_DECIMAL);
        df.setRoundingMode(RoundingMode.HALF_UP);
        return Double.parseDouble(df.format(cpuUsage));
    }

    public static List<String> getUserList() {
        try {
            if (SystemUtils.IS_OS_MAC) {
                return OSUtils.getUserListFromMac();
            }
            if (SystemUtils.IS_OS_WINDOWS) {
                return OSUtils.getUserListFromWindows();
            }
            return OSUtils.getUserListFromLinux();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    private static List<String> getUserListFromLinux() throws IOException {
        ArrayList<String> userList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream("/etc/passwd")));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (!line.contains(":")) continue;
                String[] userInfo = line.split(":");
                userList.add(userInfo[0]);
            }
        }
        return userList;
    }

    private static List<String> getUserListFromMac() throws IOException {
        String result = OSUtils.exeCmd("dscl . list /users");
        if (!StringUtils.isEmpty((String)result)) {
            return Arrays.asList(result.split("\n"));
        }
        return Collections.emptyList();
    }

    private static List<String> getUserListFromWindows() throws IOException {
        String result = OSUtils.exeCmd("net user");
        String[] lines = result.split("\n");
        int startPos = 0;
        int endPos = lines.length - 2;
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].isEmpty()) continue;
            int count = 0;
            if (lines[i].charAt(0) == '-') {
                for (int j = 0; j < lines[i].length(); ++j) {
                    if (lines[i].charAt(i) != '-') continue;
                    ++count;
                }
            }
            if (count != lines[i].length()) continue;
            startPos = i + 1;
            break;
        }
        ArrayList<String> users = new ArrayList<String>();
        while (startPos <= endPos) {
            users.addAll(Arrays.asList(PATTERN.split(lines[startPos])));
            ++startPos;
        }
        return users;
    }

    public static void createUserIfAbsent(String userName) {
        if (!OSUtils.getUserList().contains(userName)) {
            boolean isSuccess = OSUtils.createUser(userName);
            logger.info("create user {} {}", (Object)userName, (Object)(isSuccess ? "success" : "fail"));
        }
    }

    public static boolean createUser(String userName) {
        try {
            String userGroup = OSUtils.getGroup();
            if (StringUtils.isEmpty((String)userGroup)) {
                String errorLog = String.format("%s group does not exist for this operating system.", userGroup);
                logger.error(errorLog);
                return false;
            }
            if (SystemUtils.IS_OS_MAC) {
                OSUtils.createMacUser(userName, userGroup);
            } else if (SystemUtils.IS_OS_WINDOWS) {
                OSUtils.createWindowsUser(userName, userGroup);
            } else {
                OSUtils.createLinuxUser(userName, userGroup);
            }
            return true;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void createLinuxUser(String userName, String userGroup) throws IOException {
        logger.info("create linux os user: {}", (Object)userName);
        String cmd = String.format("sudo useradd -g %s %s", userGroup, userName);
        logger.info("execute cmd: {}", (Object)cmd);
        OSUtils.exeCmd(cmd);
    }

    private static void createMacUser(String userName, String userGroup) throws IOException {
        logger.info("create mac os user: {}", (Object)userName);
        String createUserCmd = String.format("sudo sysadminctl -addUser %s -password %s", userName, userName);
        logger.info("create user command: {}", (Object)createUserCmd);
        OSUtils.exeCmd(createUserCmd);
        String appendGroupCmd = String.format("sudo dseditgroup -o edit -a %s -t user %s", userName, userGroup);
        logger.info("append user to group: {}", (Object)appendGroupCmd);
        OSUtils.exeCmd(appendGroupCmd);
    }

    private static void createWindowsUser(String userName, String userGroup) throws IOException {
        logger.info("create windows os user: {}", (Object)userName);
        String userCreateCmd = String.format("net user \"%s\" /add", userName);
        logger.info("execute create user command: {}", (Object)userCreateCmd);
        OSUtils.exeCmd(userCreateCmd);
        String appendGroupCmd = String.format("net localgroup \"%s\" \"%s\" /add", userGroup, userName);
        logger.info("execute append user to group: {}", (Object)appendGroupCmd);
        OSUtils.exeCmd(appendGroupCmd);
    }

    public static String getGroup() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            String currentProcUserName = System.getProperty("user.name");
            String result = OSUtils.exeCmd(String.format("net user \"%s\"", currentProcUserName));
            String line = result.split("\n")[22];
            String group = PATTERN.split(line)[1];
            if (group.charAt(0) == '*') {
                return group.substring(1);
            }
            return group;
        }
        String result = OSUtils.exeCmd("groups");
        if (!StringUtils.isEmpty((String)result)) {
            String[] groupInfo = result.split(" ");
            return groupInfo[0];
        }
        return null;
    }

    public static String getSudoCmd(String tenantCode, String command) {
        if (!CommonUtils.isSudoEnable() || StringUtils.isEmpty((String)tenantCode)) {
            return command;
        }
        return String.format("sudo -u %s %s", tenantCode, command);
    }

    public static String exeCmd(String command) throws IOException {
        StringTokenizer st = new StringTokenizer(command);
        String[] cmdArray = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            cmdArray[i] = st.nextToken();
            ++i;
        }
        return OSUtils.exeShell(cmdArray);
    }

    public static String exeShell(String[] command) throws IOException {
        return ShellExecutor.execCommand(command);
    }

    public static int getProcessID() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return Integer.parseInt(runtimeMXBean.getName().split("@")[0]);
    }

    public static Boolean checkResource(double maxCpuloadAvg, double reservedMemory) {
        double loadAverage = OSUtils.loadAverage();
        double availablePhysicalMemorySize = OSUtils.availablePhysicalMemorySize();
        if (loadAverage > maxCpuloadAvg || availablePhysicalMemorySize < reservedMemory) {
            logger.warn("current cpu load average {} is too high or available memory {}G is too low, under max.cpuload.avg={} and reserved.memory={}G", new Object[]{loadAverage, availablePhysicalMemorySize, maxCpuloadAvg, reservedMemory});
            return false;
        }
        return true;
    }
}

