/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import org.apache.dolphinscheduler.common.task.AbstractParameters;
import org.apache.dolphinscheduler.common.task.conditions.ConditionsParameters;
import org.apache.dolphinscheduler.common.task.datax.DataxParameters;
import org.apache.dolphinscheduler.common.task.dependent.DependentParameters;
import org.apache.dolphinscheduler.common.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.common.task.http.HttpParameters;
import org.apache.dolphinscheduler.common.task.mr.MapReduceParameters;
import org.apache.dolphinscheduler.common.task.procedure.ProcedureParameters;
import org.apache.dolphinscheduler.common.task.python.PythonParameters;
import org.apache.dolphinscheduler.common.task.shell.ShellParameters;
import org.apache.dolphinscheduler.common.task.spark.SparkParameters;
import org.apache.dolphinscheduler.common.task.sql.SqlParameters;
import org.apache.dolphinscheduler.common.task.sqoop.SqoopParameters;
import org.apache.dolphinscheduler.common.task.subprocess.SubProcessParameters;
import org.apache.dolphinscheduler.common.task.switchtask.SwitchParameters;
import org.apache.dolphinscheduler.common.task.tis.PigeonCommonParameters;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskParametersUtils {
    private static final Logger logger = LoggerFactory.getLogger(TaskParametersUtils.class);

    private TaskParametersUtils() {
        throw new UnsupportedOperationException("Construct TaskParametersUtils");
    }

    public static AbstractParameters getParameters(String taskType, String parameter) {
        switch (taskType) {
            case "SUB_PROCESS": {
                return JSONUtils.parseObject(parameter, SubProcessParameters.class);
            }
            case "SHELL": 
            case "WATERDROP": {
                return JSONUtils.parseObject(parameter, ShellParameters.class);
            }
            case "PROCEDURE": {
                return JSONUtils.parseObject(parameter, ProcedureParameters.class);
            }
            case "SQL": {
                return JSONUtils.parseObject(parameter, SqlParameters.class);
            }
            case "MR": {
                return JSONUtils.parseObject(parameter, MapReduceParameters.class);
            }
            case "SPARK": {
                return JSONUtils.parseObject(parameter, SparkParameters.class);
            }
            case "PYTHON": {
                return JSONUtils.parseObject(parameter, PythonParameters.class);
            }
            case "DEPENDENT": {
                return JSONUtils.parseObject(parameter, DependentParameters.class);
            }
            case "FLINK": {
                return JSONUtils.parseObject(parameter, FlinkParameters.class);
            }
            case "HTTP": {
                return JSONUtils.parseObject(parameter, HttpParameters.class);
            }
            case "DATAX": {
                return JSONUtils.parseObject(parameter, DataxParameters.class);
            }
            case "CONDITIONS": {
                return JSONUtils.parseObject(parameter, ConditionsParameters.class);
            }
            case "SQOOP": {
                return JSONUtils.parseObject(parameter, SqoopParameters.class);
            }
            case "SWITCH": {
                return JSONUtils.parseObject(parameter, SwitchParameters.class);
            }
            case "PIGEON": {
                return JSONUtils.parseObject(parameter, PigeonCommonParameters.class);
            }
        }
        logger.error("not support task type: {}", (Object)taskType);
        return null;
    }
}

