/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

export default {
  list: {
    create_project: 'Create Project',
    edit_project: 'Edit Project',
    project_list: 'Project List',
    project_tips: 'Please enter your project',
    description_tips: 'Please enter your description',
    username_tips: 'Please enter your username',
    project_name: 'Project Name',
    project_description: 'Project Description',
    owned_users: 'Owned Users',
    workflow_define_count: 'Workflow Define Count',
    process_instance_running_count: 'Process Instance Running Count',
    description: 'Description',
    create_time: 'Create Time',
    update_time: 'Update Time',
    operation: 'Operation',
    edit: 'Edit',
    delete: 'Delete',
    confirm: 'Confirm',
    cancel: 'Cancel',
    delete_confirm: 'Delete?',
    authorize_level: 'Authorize Level',
    no_permission: 'No Permission',
    read_permission: 'Read Permission',
    all_permission: 'All Permission'
  },
  workflow: {
    on_line: 'Online',
    test: 'Test',
    operating_environment: 'Operating Environment',
    workflow_relation: 'Workflow Relation',
    create_workflow: 'Create Workflow',
    create_workflow_dynamic: 'Create Workflow (Dynamic)',
    import_workflow: 'Import Workflow',
    workflow_name: 'Workflow Name',
    workflow_instance_name: 'Workflow Instance Name',
    current_selection: 'Current Selection',
    online: 'Online',
    offline: 'Offline',
    refresh: 'Refresh',
    show_hide_label: 'Show / Hide Label',
    workflow_offline: 'Workflow Offline',
    schedule_offline: 'Schedule Offline',
    schedule_start_time: 'Schedule Start Time',
    schedule_end_time: 'Schedule End Time',
    crontab_expression: 'Crontab',
    workflow_publish_status: 'Workflow Publish Status',
    schedule_publish_status: 'Schedule Publish Status',
    workflow_definition: 'Workflow Definition',
    workflow_timing: 'Workflow Timing',
    workflow_instance: 'Workflow Instance',
    status: 'Status',
    create_time: 'Create Time',
    update_time: 'Update Time',
    description: 'Description',
    create_user: 'Create User',
    modify_user: 'Modify User',
    operation: 'Operation',
    edit: 'Edit',
    confirm: 'Confirm',
    cancel: 'Cancel',
    start: 'Start',
    timing: 'Timing',
    timezone: 'Timezone',
    up_line: 'Online',
    down_line: 'Offline',
    copy_workflow: 'Copy Workflow',
    copy_workflow_name: 'Copy workflow name',
    visit_workflow_instances: 'Visit workflow instances',
    cron_manage: 'Timing Management',
    delete: 'Delete',
    tree_view: 'Tree View',
    tree_limit: 'Limit Size',
    export: 'Export',
    batch_copy: 'Batch Copy',
    batch_delete: 'Batch Delete',
    batch_export: 'Batch Export',
    version_info: 'Version Info',
    version: 'Version',
    file_upload: 'File Upload',
    upload_file: 'Upload File',
    upload: 'Upload',
    file_name: 'File Name',
    success: 'Success',
    set_parameters_before_starting: 'Please set the parameters before starting',
    set_parameters_before_timing: 'Set parameters before timing',
    start_and_stop_time: 'Start and stop time',
    next_five_execution_times: 'Next five execution times',
    execute_time: 'Execute time',
    failure_strategy: 'Failure Strategy',
    node_execution: 'Node Execution',
    backward_execution: 'Backward execution',
    forward_execution: 'Forward execution',
    current_node_execution: 'Execute only the current node',
    backward_execution_task: 'Run backwards',
    forward_execution_task: 'Run forwards',
    current_node_execution_task: 'Run',
    notification_strategy: 'Notification Strategy',
    workflow_priority: 'Workflow Priority',
    worker_group: 'Worker Group',
    tenant_code: 'Tenant',
    environment_name: 'Environment Name',
    alarm_group: 'Alarm Group',
    complement_data: 'Complement Data',
    startup_parameter: 'Startup Parameter',
    whether_dry_run: 'Whether Dry-Run',
    whether_test: 'Whether Test',
    continue: 'Continue',
    end: 'End',
    none_send: 'None',
    success_send: 'Success',
    failure_send: 'Failure',
    all_send: 'All',
    whether_complement_data: 'Whether it is a complement process?',
    schedule_date: 'Schedule date',
    select_date: 'Select Date',
    enter_date: 'Enter Date',
    schedule_date_tips:
      'The format is yyyy-MM-dd HH:mm:ss with multiple comma splits',
    schedule_date_limit: 'Enter more than 100 dates',
    mode_of_execution: 'Mode of execution',
    serial_execution: 'Serial execution',
    parallel_execution: 'Parallel execution',
    parallelism: 'Parallelism',
    custom_parallelism: 'Custom Parallelism',
    please_enter_parallelism: 'Please enter Parallelism',
    order_of_execution: 'Order of execution',
    ascending_order: 'In ascending order',
    descending_order: 'In descending order',
    please_choose: 'Please Choose',
    start_time: 'Start Time',
    end_time: 'End Time',
    crontab: 'Crontab',
    delete_confirm: 'Delete?',
    enter_name_tips: 'Please enter name',
    switch_version: 'Switch To This Version',
    confirm_switch_version: 'Confirm Switch To This Version?',
    current_version: 'Current Version',
    run_type: 'Run Type',
    scheduling_time: 'Scheduling Time',
    duration: 'Duration',
    run_times: 'Run Times',
    fault_tolerant_sign: 'Fault-tolerant Sign',
    dry_run_flag: 'Dry-run Flag',
    executor: 'Executor',
    host: 'Host',
    start_process: 'Start Process',
    execute_from_the_current_node: 'Execute from the current node',
    recover_tolerance_fault_process: 'Recover tolerance fault process',
    resume_the_suspension_process: 'Resume the suspension process',
    execute_from_the_failed_nodes: 'Execute from the failed nodes',
    scheduling_execution: 'Scheduling execution',
    rerun: 'Rerun',
    stop: 'Stop',
    pause: 'Pause',
    recovery_waiting_thread: 'Recovery waiting thread',
    recover_serial_wait: 'Recover serial wait',
    execute_task: 'Execute the specified task',
    dynamic_generation: 'Dynamic Generation',
    recovery_suspend: 'Recovery Suspend',
    recovery_failed: 'Recovery Failed',
    gantt: 'Gantt',
    name: 'Name',
    all_status: 'AllStatus',
    submit_success: 'Submitted successfully',
    running: 'Running',
    ready_to_pause: 'Ready to pause',
    ready_to_stop: 'Ready to stop',
    failed: 'Failed',
    need_fault_tolerance: 'Need fault tolerance',
    kill: 'Kill',
    waiting_for_thread: 'Waiting for thread',
    waiting_for_dependence: 'Waiting for dependence',
    waiting_for_dependency_to_complete: 'Waiting for dependency to complete',
    delay_execution: 'Delay execution',
    forced_success: 'Forced success',
    serial_wait: 'Serial wait',
    dispatch: 'Dispatch',
    pending: 'Pending',
    executing: 'Executing',
    startup_type: 'Startup Type',
    complement_range: 'Complement Range',
    parameters_variables: 'Parameters variables',
    global_parameters: 'Global parameters',
    local_parameters: 'Local parameters',
    type: 'Type',
    retry_count: 'Retry Count',
    submit_time: 'Submit Time',
    refresh_status_succeeded: 'Refresh status succeeded',
    view_log: 'View log',
    update_log_success: 'Update log success',
    no_more_log: 'No more logs',
    no_log: 'No log',
    loading_log: 'Loading Log...',
    close: 'Close',
    download_log: 'Download Log',
    refresh_log: 'Refresh Log',
    enter_full_screen: 'Enter full screen',
    cancel_full_screen: 'Cancel full screen',
    task_state: 'Task status',
    mode_of_dependent: 'Mode of dependent',
    all_level_dependent: 'all level dependent',
    open: 'Open',
    project_name_required: 'Project name is required',
    related_items: 'Related items',
    project_name: 'Project Name',
    project_tips: 'Please select project name',
    workflow_relation_no_data_result_title:
      'Can not find any relations of workflows.',
    workflow_relation_no_data_result_desc:
      'There is not any workflows. Please create a workflow, and then visit this page again.',
    ready_to_block: 'Ready to block',
    block: 'Block',
    want_to_set_timing: 'Would you like to set the workflow timing?',
    confirm_to_online: 'Confirm to make the workflow online?',
    confirm_to_offline: 'Confirm to make the workflow offline?',
  },
  task: {
    on_line: 'Online',
    test: 'Test',
    operating_environment: 'Operating Environment',
    cancel_full_screen: 'Cancel full screen',
    enter_full_screen: 'Enter full screen',
    current_task_settings: 'Current task settings',
    online: 'Online',
    offline: 'Offline',
    task_name: 'Task Name',
    task_code: 'Task Code',
    task_type: 'Task Type',
    create_task: 'Create Task',
    workflow_instance: 'Workflow Instance',
    workflow_name: 'Workflow Name',
    workflow_name_tips: 'Please select workflow name',
    workflow_state: 'Workflow State',
    version: 'Version',
    current_version: 'Current Version',
    run_type: 'Run Type',
    switch_version: 'Switch To This Version',
    confirm_switch_version: 'Confirm Switch To This Version?',
    description: 'Description',
    move: 'Move',
    upstream_tasks: 'Upstream Tasks',
    executor: 'Executor',
    node_type: 'Node Type',
    state: 'State',
    submit_time: 'Submit Time',
    start_time: 'Start Time',
    create_time: 'Create Time',
    update_time: 'Update Time',
    end_time: 'End Time',
    duration: 'Duration',
    retry_count: 'Retry Count',
    dry_run_flag: 'Dry Run Flag',
    host: 'Host',
    app_link: 'External Application Link',
    operation: 'Operation',
    edit: 'Edit',
    delete: 'Delete',
    delete_confirm: 'Delete?',
    forced_success: 'Forced Success',
    view_log: 'View Log',
    download_log: 'Download Log',
    refresh: 'Refresh',
    app_id: 'Application ID',
    execute: 'Execute',
    stop: 'Stop',
    batch_task: 'Batch Task',
    stream_task: 'Stream Task',
    jump_tip: 'Jump, not open yet!',
    savepoint: 'Savepoint',
    success: 'Success',
    none_send: 'None',
    success_send: 'Success',
    failure_send: 'Failure',
    all_send: 'All',
    set_parameters_before_starting: 'Please set the parameters before starting',
    notification_strategy: 'Notification Strategy',
    worker_group: 'Worker group',
    tenant_code: 'Tenant',
    environment_name: 'Environment Name',
    alarm_group: 'Alarm group',
    startup_parameter: 'Startup Parameter',
    whether_dry_run: 'Whether Dry-Run',
    please_choose: 'Please Choose',
    remove_task_cache: 'Clear cache'
  },
  dag: {
    create: 'Create Workflow',
    search: 'Search',
    download_png: 'Download PNG',
    fullscreen_open: 'Open Fullscreen',
    fullscreen_close: 'Close Fullscreen',
    save: 'Save',
    close: 'Close',
    format: 'Format',
    refresh_dag_status: 'Refresh DAG status',
    layout_type: 'Layout Type',
    grid_layout: 'Grid',
    dagre_layout: 'Dagre',
    rows: 'Rows',
    cols: 'Cols',
    copy_success: 'Copy Success',
    workflow_name: 'Workflow Name',
    description: 'Description',
    timeout_alert: 'Timeout Alert',
    process_execute_type: 'Process execute type',
    parallel: 'parallel',
    serial_wait: 'Serial wait',
    serial_discard: 'Serial discard',
    serial_priority: 'Serial priority',
    recover_serial_wait: 'Recover serial wait',
    global_variables: 'Global Parameters',
    basic_info: 'Basic Information',
    minute: 'Minute',
    key: 'Key',
    value: 'Value',
    success: 'Success',
    delete_cell: 'Delete selected edges and nodes',
    online_directly: 'Whether to go online the workflow definition',
    update_directly: 'Whether to update the workflow definition',
    dag_name_empty: 'DAG graph name cannot be empty',
    positive_integer: 'Please enter a positive integer greater than 0',
    prop_empty: 'prop is empty',
    prop_repeat: 'prop is repeat',
    node_not_created: 'Failed to save node not created',
    copy_name: 'Copy Name',
    view_variables: 'View Variables',
    startup_parameter: 'Startup Parameter',
    online: 'Online'
  },
  node: {
    is_cache: 'Cache Execution',
    jvm_args: 'Java VM Parameters',
    jvm_args_tips: 'Please enter virtual machine parameters',
    run_type: 'Run Type',
    is_module_path: 'Use Module Path',
    return_back: 'Return',
    current_node_settings: 'Current node settings',
    instructions: 'Instructions',
    view_history: 'View history',
    view_log: 'View log',
    enter_this_child_node: 'Enter this child node',
    name: 'Node Name',
    task_name: 'Task Name',
    task_name_tips: 'Please select a task (required)',
    name_tips: 'Please enter name (required)',
    task_type: 'Task Type',
    task_type_tips: 'Please select a task type (required)',
    workflow_name: 'Workflow Name',
    workflow_name_tips: 'Please select a workflow (required)',
    child_node: 'Child Node',
    child_node_tips: 'Please select a child node (required)',
    run_flag: 'Run flag',
    normal: 'Normal',
    prohibition_execution: 'Prohibition execution',
    description: 'Description',
    description_tips: 'Please enter description',
    task_priority: 'Task priority',
    worker_group: 'Worker group',
    worker_group_tips:
      'The Worker group no longer exists, please select the correct Worker group!',
    environment_name: 'Environment Name',
    task_group_name: 'Task group name',
    task_group_queue_priority: 'Priority',
    number_of_failed_retries: 'Number of failed retries',
    cpu_quota: 'CPU quota',
    memory_max: 'Max memory',
    times: 'Times',
    failed_retry_interval: 'Failed retry interval',
    minute: 'Minute',
    second: 'Second',
    delay_execution_time: 'Delay execution time',
    namespace_cluster: 'Namespace(Cluster)',
    min_cpu: 'Min cpu',
    min_memory: 'Min memory',
    cores: 'Cores',
    mb: 'MB',
    image: 'Image',
    image_tips: 'Please enter image',
    image_pull_policy: 'Image pull policy',
    image_pull_policy_tips: 'Please select a image pull policy (required)',
    pull_secret: 'Pull secret',
    pull_secret_tips: 'Please enter pull secret',
    command: 'Command',
    command_tips:
      'Please enter the container execution command, for example: ["printenv"]',
    args: 'Args',
    args_tips:
      'Please enter the container execution command args, for example: ["HOSTNAME", "KUBERNETES_PORT"]',
    min_memory_tips: 'Please enter min memory',
    state: 'State',
    branch_flow: 'Branch flow',
    cancel: 'Cancel',
    loading: 'Loading...',
    confirm: 'Confirm',
    success: 'Success',
    failed: 'Failed',
    backfill_tips:
      'The newly created sub-Process has not yet been executed and cannot enter the sub-Process',
    task_instance_tips:
      'The task has not been executed and cannot enter the sub-Process',
    branch_tips:
      'Cannot select the same node for successful branch flow and failed branch flow',
    timeout_alarm: 'Timeout alarm',
    timeout_strategy: 'Timeout strategy',
    timeout_strategy_tips: 'Timeout strategy must be selected',
    timeout_failure: 'Timeout failure',
    timeout_period: 'Timeout period',
    timeout_period_tips: 'Timeout must be a positive integer',
    script: 'Script',
    script_tips: 'Please enter script(required)',
    init_script: 'Initialization script',
    init_script_tips: 'Please enter initialization script',
    resources: 'Resources',
    resources_tips: 'Please select resources',
    resources_limit_tips: 'Please select again, resource limit:',
    non_resources_tips: 'Please delete all non-existent resources',
    useless_resources_tips: 'Unauthorized or deleted resources',
    custom_parameters: 'Custom Parameters',
    copy_success: 'Copy success',
    copy_failed: 'The browser does not support automatic copying',
    prop_tips: 'prop(required)',
    prop_repeat: 'prop is repeat',
    value_tips: 'value(optional)',
    value_required_tips: 'value(required)',
    custom_labels: 'Customized labels',
    node_selectors: 'Node Selectors',
    label_repeat: 'repeated label',
    label_name_tips: 'label name(required)',
    label_value_tips: 'label value(required)',
    expression_name_tips: 'expression label key(required)',
    expression_value_tips: 'expression values(optional)',
    pre_tasks: 'Pre tasks',
    program_type: 'Program Type',
    main_class: 'Main Class',
    main_class_tips: 'Please enter main class',
    main_package: 'Main Package',
    main_package_tips: 'Please enter main package',
    deploy_mode: 'Deploy Mode',
    app_name: 'App Name',
    app_name_tips: 'Please enter app name(optional)',
    driver_cores: 'Driver Cores',
    driver_cores_tips: 'Please enter Driver cores',
    driver_memory: 'Driver Memory',
    driver_memory_tips: 'Please enter Driver memory',
    executor_number: 'Executor Number',
    executor_number_tips: 'Please enter Executor number',
    executor_memory: 'Executor Memory',
    executor_memory_tips: 'Please enter Executor memory',
    executor_cores: 'Executor Cores',
    executor_cores_tips: 'Please enter Executor cores',
    main_arguments: 'Main Arguments',
    main_arguments_tips: 'Please enter main arguments',
    option_parameters: 'Option Parameters',
    option_parameters_tips: 'Please enter option parameters',
    positive_integer_tips: 'should be a positive integer',
    flink_version: 'Flink Version',
    job_manager_memory: 'JobManager Memory',
    job_manager_memory_tips: 'Please enter JobManager memory',
    task_manager_memory: 'TaskManager Memory',
    task_manager_memory_tips: 'Please enter TaskManager memory',
    slot_number: 'Slot Number',
    slot_number_tips: 'Please enter Slot number',
    parallelism: 'Parallelism',
    custom_parallelism: 'Configure parallelism',
    parallelism_tips: 'Please enter Parallelism',
    parallelism_number_tips: 'Parallelism number should be positive integer',
    parallelism_complement_tips:
      'If there are a large number of tasks requiring complement, you can use the custom parallelism to ' +
      'set the complement task thread to a reasonable value to avoid too large impact on the server.',
    task_manager_number: 'TaskManager Number',
    task_manager_number_tips: 'Please enter TaskManager number',
    http_url: 'Http Url',
    http_url_tips: 'Please Enter Http Url',
    http_url_validator: 'The request address must contain HTTP or HTTPS',
    http_method: 'Http Method',
    http_parameters: 'Http Parameters',
    http_check_condition: 'Http Check Condition',
    http_condition: 'Http Condition',
    http_condition_tips: 'Please Enter Http Condition',
    timeout_settings: 'Timeout Settings',
    connect_timeout: 'Connect Timeout',
    ms: 'ms',
    socket_timeout: 'Socket Timeout',
    status_code_default: 'Default response code 200',
    status_code_custom: 'Custom response code',
    body_contains: 'Content includes',
    body_not_contains: 'Content does not contain',
    http_parameters_position: 'Http Parameters Position',
    target_task_name: 'Target Task Name',
    target_task_name_tips: 'Please enter the Pigeon task name(required)',
    datasource_type: 'Datasource types',
    datasource_instances: 'Datasource instances',
    sql_type: 'SQL Type',
    sql_type_query: 'Query',
    sql_type_non_query: 'Non Query',
    sql_statement: 'SQL Statement',
    pre_sql_statement: 'Pre SQL Statement',
    post_sql_statement: 'Post SQL Statement',
    sql_input_placeholder: 'Please enter non-query sql.',
    sql_empty_tips: 'The sql can not be empty.',
    procedure_method: 'SQL Statement',
    procedure_method_tips: 'Please enter the procedure script',
    procedure_method_snippet:
      '--Please enter the procedure script \n\n--call procedure:call <procedure-name>[(<arg1>,<arg2>, ...)]\n\n--call function:?= call <procedure-name>[(<arg1>,<arg2>, ...)]',
    start: 'Start',
    edit: 'Edit',
    copy: 'Copy',
    delete: 'Delete',
    custom_job: 'Custom Job',
    custom_script: 'Custom Script',
    sqoop_job_name: 'Job Name',
    sqoop_job_name_tips: 'Please enter Job Name(required)',
    direct: 'Direct',
    hadoop_custom_params: 'Hadoop Params',
    sqoop_advanced_parameters: 'Sqoop Advanced Parameters',
    data_source: 'Data Source',
    type: 'Type',
    datasource: 'Datasource',
    datasource_tips: 'Please select the datasource',
    model_type: 'ModelType',
    form: 'Form',
    table: 'Table',
    table_tips: 'Please enter Mysql Table(required)',
    column_type: 'ColumnType',
    all_columns: 'All Columns',
    some_columns: 'Some Columns',
    column: 'Column',
    column_tips: 'Please enter Columns (Comma separated)',
    database: 'Database',
    database_tips: 'Please enter Hive Database(required)',
    hive_table_tips: 'Please enter Hive Table(required)',
    hive_partition_keys: 'Hive partition Keys',
    hive_partition_keys_tips: 'Please enter Hive Partition Keys',
    hive_partition_values: 'Hive partition Values',
    hive_partition_values_tips: 'Please enter Hive Partition Values',
    export_dir: 'Export Dir',
    export_dir_tips: 'Please enter Export Dir(required)',
    sql_statement_tips: 'SQL Statement(required)',
    map_column_hive: 'Map Column Hive',
    map_column_java: 'Map Column Java',
    data_target: 'Data Target',
    create_hive_table: 'CreateHiveTable',
    drop_delimiter: 'DropDelimiter',
    over_write_src: 'OverWriteSrc',
    hive_target_dir: 'Hive Target Dir',
    hive_target_dir_tips: 'Please enter hive target dir',
    replace_delimiter: 'ReplaceDelimiter',
    replace_delimiter_tips: 'Please enter Replace Delimiter',
    target_dir: 'Target Dir',
    target_dir_tips: 'Please enter Target Dir(required)',
    delete_target_dir: 'DeleteTargetDir',
    compression_codec: 'CompressionCodec',
    file_type: 'FileType',
    fields_terminated: 'FieldsTerminated',
    fields_terminated_tips: 'Please enter Fields Terminated',
    lines_terminated: 'LinesTerminated',
    lines_terminated_tips: 'Please enter Lines Terminated',
    is_update: 'IsUpdate',
    update_key: 'UpdateKey',
    update_key_tips: 'Please enter Update Key',
    update_mode: 'UpdateMode',
    only_update: 'OnlyUpdate',
    allow_insert: 'AllowInsert',
    concurrency: 'Concurrency',
    concurrency_tips: 'Please enter Concurrency',
    concurrency_column: 'Concurrency Column',
    concurrency_column_tips: 'Please enter Concurrency Column',
    sea_tunnel_master: 'Master',
    sea_tunnel_master_url: 'Master URL',
    sea_tunnel_queue: 'Queue',
    sea_tunnel_master_url_tips:
      'Please enter the master url, e.g., 127.0.0.1:7077',
    add_pre_task_check_condition: 'Add pre task check condition',
    switch_condition: 'Condition',
    switch_branch_flow: 'Branch Flow',
    switch_branch_flow_default: 'Default Branch Flow',
    switch_branch_flow_tips: 'Please select branch flow',
    and: 'and',
    or: 'or',
    datax_custom_template: 'Custom Template',
    datax_json_template: 'JSON',
    datax_target_datasource_type: 'Target Datasource Types',
    datax_target_database: 'Target Database',
    datax_target_table: 'Target Table',
    datax_target_table_tips: 'Please enter the name of the target table',
    datax_target_database_pre_sql: 'Pre SQL Statement',
    datax_target_database_post_sql: 'Post SQL Statement',
    datax_non_query_sql_tips: 'Please enter the non-query sql statement',
    datax_job_speed_byte: 'Speed(Byte count)',
    datax_job_speed_byte_info: '(0 means unlimited)',
    datax_job_speed_record: 'Speed(Record count)',
    datax_job_speed_record_info: '(0 means unlimited)',
    datax_job_runtime_memory: 'Runtime Memory Limits',
    datax_job_runtime_memory_xms: 'Low Limit Value',
    datax_job_runtime_memory_xmx: 'High Limit Value',
    datax_job_runtime_memory_unit: 'G',
    chunjun_json_template: 'JSON script',
    current_hour: 'CurrentHour',
    last_1_hour: 'Last1Hour',
    last_2_hour: 'Last2Hours',
    last_3_hour: 'Last3Hours',
    last_24_hour: 'Last24Hours',
    today: 'today',
    last_1_days: 'Last1Days',
    last_2_days: 'Last2Days',
    last_3_days: 'Last3Days',
    last_7_days: 'Last7Days',
    this_week: 'ThisWeek',
    last_week: 'LastWeek',
    last_monday: 'LastMonday',
    last_tuesday: 'LastTuesday',
    last_wednesday: 'LastWednesday',
    last_thursday: 'LastThursday',
    last_friday: 'LastFriday',
    last_saturday: 'LastSaturday',
    last_sunday: 'LastSunday',
    this_month: 'ThisMonth',
    this_month_begin: 'ThisMonthBegin',
    last_month: 'LastMonth',
    last_month_begin: 'LastMonthBegin',
    last_month_end: 'LastMonthEnd',
    month: 'month',
    week: 'week',
    day: 'day',
    hour: 'hour',
    add_dependency: 'Add dependency',
    waiting_dependent_start: 'Waiting Dependent start',
    check_interval: 'Check interval',
    check_interval_tips: 'Check interval must be a positive integer',
    waiting_dependent_complete: 'Waiting Dependent complete',
    project_name: 'Project Name',
    project_name_tips: 'Please select a project(required)',
    process_name: 'Workflow Name',
    process_name_tips: 'Please select a workflow(required)',
    cycle_time: 'Cycle Time',
    cycle_time_tips: 'Please select a cycle time(required)',
    date_tips: 'Please select a date(required)',
    rule_name: 'Rule Name',
    null_check: 'NullCheck',
    custom_sql: 'CustomSql',
    multi_table_accuracy: 'MulTableAccuracy',
    multi_table_value_comparison: 'MulTableCompare',
    field_length_check: 'FieldLengthCheck',
    uniqueness_check: 'UniquenessCheck',
    regexp_check: 'RegexpCheck',
    timeliness_check: 'TimelinessCheck',
    enumeration_check: 'EnumerationCheck',
    table_count_check: 'TableCountCheck',
    src_connector_type: 'SrcConnType',
    src_datasource_id: 'SrcSource',
    src_database: 'SrcDatabase',
    src_table: 'SrcTable',
    src_filter: 'SrcFilter',
    src_field: 'SrcField',
    statistics_name: 'ActualValName',
    check_type: 'CheckType',
    operator: 'Operator',
    threshold: 'Threshold',
    failure_strategy: 'FailureStrategy',
    target_connector_type: 'TargetConnType',
    target_datasource_id: 'TargetSourceId',
    target_database: 'TargetDatabase',
    target_table: 'TargetTable',
    target_filter: 'TargetFilter',
    mapping_columns: 'OnClause',
    statistics_execute_sql: 'ActualValExecSql',
    comparison_name: 'ExceptedValName',
    comparison_execute_sql: 'ExceptedValExecSql',
    comparison_type: 'ExceptedValType',
    writer_connector_type: 'WriterConnType',
    writer_datasource_id: 'WriterSourceId',
    target_field: 'TargetField',
    field_length: 'FieldLength',
    logic_operator: 'LogicOperator',
    regexp_pattern: 'RegexpPattern',
    deadline: 'Deadline',
    datetime_format: 'DatetimeFormat',
    enum_list: 'EnumList',
    begin_time: 'BeginTime',
    fix_value: 'FixValue',
    required: 'required',
    emr_flow_define_json: 'jobFlowDefineJson',
    emr_flow_define_json_tips: 'Please enter the definition of the job flow.',
    emr_steps_define_json: 'stepsDefineJson',
    emr_steps_define_json_tips: 'Please enter the definition of the emr step.',
    zeppelin_note_id: 'zeppelinNoteId',
    zeppelin_note_id_tips: 'Please enter the note id of your zeppelin note',
    zeppelin_paragraph_id: 'zeppelinParagraphId',
    zeppelin_paragraph_id_tips:
      'Please enter the paragraph id of your zeppelin paragraph',
    zeppelin_parameters: 'parameters',
    zeppelin_parameters_tips:
      'Please enter the parameters for zeppelin dynamic form',
    zeppelin_rest_endpoint: 'zeppelinRestEndpoint',
    zeppelin_rest_endpoint_tips:
      'Please enter the rest endpoint of your Zeppelin server',
    zeppelin_production_note_directory:
      'Directory for cloned zeppelin note in production mode',
    zeppelin_production_note_directory_tips:
      'Please enter the production note directory to enable production mode',
    zeppelin_username: 'zeppelinUsername',
    zeppelin_username_tips: 'Please enter the zeppelin server username',
    zeppelin_password: 'zeppelinPassword',
    zeppelin_password_tips: 'Please enter the zeppelin server password',
    sql_execution_type: 'SQL Input',
    sql_execution_type_from_file: 'FROM_FILE',
    sql_execution_type_from_script: 'FROM_SCRIPT',
    hive_cli_task_execution_type: 'Hive Cli Task Execution Type',
    hive_sql_script: 'Hive SQL Script',
    hive_cli_options: 'Hive Cli Options',
    hive_cli_options_tips:
      'Please enter the options for hive cli, e.g. --verbose',
    jupyter_conda_env_name: 'condaEnvName',
    jupyter_conda_env_name_tips:
      'Please enter the conda environment name of papermill',
    jupyter_input_note_path: 'inputNotePath',
    jupyter_input_note_path_tips: 'Please enter the input jupyter note path',
    jupyter_output_note_path: 'outputNotePath',
    jupyter_output_note_path_tips: 'Please enter the output jupyter note path',
    jupyter_parameters: 'parameters',
    jupyter_parameters_tips:
      'Please enter the parameters for jupyter parameterization',
    jupyter_kernel: 'kernel',
    jupyter_kernel_tips: 'Please enter the jupyter kernel name',
    jupyter_engine: 'engine',
    jupyter_engine_tips: 'Please enter the engine name',
    jupyter_execution_timeout: 'executionTimeout',
    jupyter_execution_timeout_tips:
      'Please enter the execution timeout for each jupyter note cell',
    jupyter_start_timeout: 'startTimeout',
    jupyter_start_timeout_tips:
      'Please enter the start timeout for jupyter kernel',
    jupyter_others: 'others',
    jupyter_others_tips:
      'Please enter the other options you need for papermill',
    mlflow_algorithm: 'Algorithm',
    mlflow_algorithm_tips: 'svm',
    mlflow_params: 'Parameters',
    mlflow_params_tips: ' ',
    mlflow_searchParams: 'Parameter Search Space',
    mlflow_searchParams_tips: ' ',
    mlflow_isSearchParams: 'Search Parameters',
    mlflow_dataPath: 'Data Path',
    mlflow_dataPath_tips:
      ' The absolute path of the file or folder. Ends with .csv for file or contain train.csv and test.csv for folder',
    mlflow_dataPath_error_tips: ' data data can not be empty ',
    mlflow_experimentName: 'Experiment Name',
    mlflow_experimentName_tips: 'experiment_001',
    mlflow_registerModel: 'Register Model',
    mlflow_modelName: 'Model Name',
    mlflow_modelName_tips: 'model_001',
    mlflow_mlflowTrackingUri: 'MLflow Tracking Server URI',
    mlflow_mlflowTrackingUri_tips: 'http://127.0.0.1:5000',
    mlflow_mlflowTrackingUri_error_tips:
      'MLflow Tracking Server URI can not be empty',
    mlflow_jobType: 'Job Type',
    mlflow_automlTool: 'AutoML Tool',
    mlflow_taskType: 'MLflow Task Type',
    mlflow_deployType: 'Deploy Mode',
    mlflow_deployModelKey: 'Model-URI',
    mlflow_deployPort: 'Port',
    mlflowProjectRepository: 'Repository',
    mlflowProjectRepository_tips: 'git repository or path on worker',
    mlflowProjectVersion: 'Project Version',
    mlflowProjectVersion_tips: 'git version',
    mlflow_cpuLimit: 'Max Cpu Limit',
    mlflow_memoryLimit: 'Max Memory Limit',
    openmldb_zk_address: 'zookeeper address',
    openmldb_zk_address_tips: 'Please enter the zookeeper address',
    openmldb_zk_path: 'zookeeper path',
    openmldb_zk_path_tips: 'Please enter the zookeeper path',
    openmldb_execute_mode: 'Execute Mode',
    openmldb_execute_mode_tips: 'Please select the execute mode',
    openmldb_execute_mode_offline: 'offline',
    openmldb_execute_mode_online: 'online',
    dvc_task_type: 'DVC Task Type',
    dvc_repository: 'DVC Repository',
    dvc_repository_tips: 'please input the url of dvc repository',
    dvc_version: 'Version',
    dvc_version_tips: 'data version, will be mark as git tag',
    dvc_data_location: 'Data Path in DVC Repository',
    dvc_message: 'Version Message',
    dvc_load_save_data_path: 'Data Path In Worker',
    dvc_store_url: 'Store Url',
    dvc_empty_tips: 'This parameter cannot be empty',
    send_email: 'Send Email',
    log_display: 'Log display',
    rows_of_result: 'rows of result',
    title: 'Title',
    title_tips: 'Please enter the title of email',
    alarm_group: 'Alarm group',
    alarm_group_tips: 'Alarm group required',
    integer_tips: 'Please enter a positive integer',
    sql_parameter: 'SQL Parameter',
    format_tips: 'Please enter format',
    udf_function: 'UDF Function',
    unlimited: 'unlimited',
    please_select_source_connector_type: 'Please select source connector type',
    please_select_source_datasource_id: 'Please select source datasource id',
    please_select_source_database: 'Please select source database',
    please_enter_source_table_name: 'Please select source table name',
    please_enter_filter_expression: 'Please enter filter expression',
    please_enter_column_only_single_column_is_supported:
      'Please select column, only single column is supported',
    please_select_target_connector_type: 'Please select target connector type',
    please_select_target_datasource: 'Please select target datasource id',
    please_select_target_database: 'Please select target database',
    please_enter_target_table: 'Please select target table name',
    please_enter_target_filter_expression: 'Please enter target filter expression',
    please_enter_comparison_name_the_alias_in_comparison_execute_sql: 'Please enter comparison name the alias in comparison execute sql',
    please_enter_statistics_name_the_alias_in_statistics_execute_sql: 'Please enter statistics name the alias in statistics execute sql',
    please_enter_comparison_execute_sql: 'Please enter comparison execute sql',
    please_enter_statistics_execute_sql: 'Please enter statistics execute sql',
    please_enter_threshold_number_is_needed:
      'Please enter threshold number is needed',
    please_enter_comparison_title: 'please select comparison title',
    custom_config: 'Custom Config',
    engine: 'engine',
    engine_tips: 'Please select engine',
    startup_script: 'Startup script',
    startup_script_tips: 'Please select startup script',
    run_mode: 'Run Mode',
    dinky_address: 'Dinky address',
    dinky_address_tips: 'Please enter the url of your dinky',
    dinky_task_id: 'Dinky task id',
    dinky_task_id_tips: 'Please enter the task id of your dinky',
    dinky_online: 'Online task',
    pytorch_script: 'Python Script',
    pytorch_script_params: 'Script Input Parameters',
    pytorch_other_params: 'Show More Configurations',
    pytorch_python_path: 'Project Path',
    pytorch_is_create_environment: 'Create An Environment Or Not',
    pytorch_python_command: 'Python Command Path',
    pytorch_python_command_tips: 'If empty，will be set $PYTHON_LAUNCHER',
    pytorch_python_env_tool: 'Python Environment Manager Tool',
    pytorch_requirements: 'Requirement File',
    pytorch_conda_python_version: 'Python Version',
    pytorch_conda_python_version_tips:
      'Please enter the version number, such as 3.6, 3.7, 3.x',
    factory_name: 'Factory Name',
    resource_group_name: 'Resource Group Name',
    pipeline_name: 'Pipeline Name',
    factory_tips: 'Please select factory',
    resource_group_tips: 'Please select resource group',
    pipeline_tips: 'Please select pipeline',
    dependent_failure_policy: 'Dependent failure policy',
    dependent_failure_policy_failure: 'failure',
    dependent_failure_policy_waiting: 'waiting',
    dependent_failure_waiting_time: 'Dependent failure waiting time',
    dependent_failure_waiting_time_tips:
      'Failure waiting time must be a positive integer',
    max_num_of_sub_workflow_instances: 'max num of sub workflow instances',
    filter_condition: 'Filter Condition',
    params_value: 'Params Value',
    separator: 'Separator',
    dynamic_name_tips: 'name(required)',
    dynamic_value_tips: 'params or value(required)',
    dynamic_separator_tips: 'separator(required)',
    child_node_definition: 'child node definition',
    child_node_instance: 'child node instance',
    yarn_queue: 'Yarn Queue',
    yarn_queue_tips: 'Please input yarn queue(optional)',
  },
  menu: {
    fav: 'Favorites',
    universal: 'Universal',
    cloud: 'Cloud',
    logic: 'Logic',
    di: 'Data Integration',
    dq: 'Data Quality',
    ml: 'Machine Learning',
    other: 'Other'
  },
  parameter: {
    create_parameter: 'Create Parameter',
    edit_parameter: 'Edit Parameter',
    parameter_manage: 'Parameter Management',
    code: 'Parameter Code',
    name: 'Parameter Name',
    value: 'Parameter Value',
    create_time: 'Create Time',
    update_time: 'Update Time',
    name_tips: 'Please enter your parameter name',
    value_tips: 'Please enter your parameter value',
    operation: 'Operation',
    edit: 'Edit',
    delete: 'Delete',
    delete_confirm: 'Delete?',
    success: 'Success',
  },
  preference: {
    edit_preference: 'Edit Preference',
    preference_manage: 'Project Preference Management',
    instruction_tips: 'The settings below will affect all workflows and tasks under this project.When creating the workflow or task, these preferences will be the default value of their components.',
    success: 'Success',
    submit: 'Submit',
    enabled: 'Enabled',
    disabled: 'Disabled'
  },
}
