/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.control.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.stream.PingFailedException;
import io.pravega.client.stream.ReaderGroupConfig;
import io.pravega.client.stream.RetentionPolicy;
import io.pravega.client.stream.ScalingPolicy;
import io.pravega.client.stream.Stream;
import io.pravega.client.stream.StreamConfiguration;
import io.pravega.client.stream.StreamCut;
import io.pravega.client.stream.Transaction;
import io.pravega.client.stream.impl.SegmentWithRange;
import io.pravega.client.stream.impl.StreamCutImpl;
import io.pravega.client.stream.impl.WriterPosition;
import io.pravega.client.tables.KeyValueTableConfiguration;
import io.pravega.common.Exceptions;
import io.pravega.controller.stream.api.grpc.v1.Controller;
import io.pravega.shared.protocol.netty.PravegaNodeUri;
import io.pravega.shared.security.auth.AccessOperation;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public final class ModelHelper {
    public static final UUID encode(Controller.TxnId txnId) {
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        return new UUID(txnId.getHighBits(), txnId.getLowBits());
    }

    public static final Segment encode(Controller.SegmentId segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return new Segment(segment.getStreamInfo().getScope(), segment.getStreamInfo().getStream(), segment.getSegmentId());
    }

    public static final ScalingPolicy encode(Controller.ScalingPolicy policy) {
        Preconditions.checkNotNull((Object)policy, (Object)"policy");
        return ScalingPolicy.builder().scaleType(ScalingPolicy.ScaleType.valueOf(policy.getScaleType().name())).targetRate(policy.getTargetRate()).scaleFactor(policy.getScaleFactor()).minNumSegments(policy.getMinNumSegments()).build();
    }

    public static final RetentionPolicy encode(Controller.RetentionPolicy policy) {
        if (policy != null && policy.getRetentionType() != Controller.RetentionPolicy.RetentionPolicyType.UNKNOWN) {
            return RetentionPolicy.builder().retentionType(RetentionPolicy.RetentionType.valueOf(policy.getRetentionType().name())).retentionParam(policy.getRetentionParam()).retentionMax(policy.getRetentionMax()).build();
        }
        return null;
    }

    public static final StreamConfiguration encode(Controller.StreamConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        return StreamConfiguration.builder().scalingPolicy(ModelHelper.encode(config.getScalingPolicy())).retentionPolicy(ModelHelper.encode(config.getRetentionPolicy())).tags((Collection<? extends String>)config.getTags().getTagList()).timestampAggregationTimeout(config.getTimestampAggregationTimeout()).rolloverSizeBytes(config.getRolloverSizeBytes()).build();
    }

    public static final KeyValueTableConfiguration encode(Controller.KeyValueTableConfig config) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)config.getScope(), (Object)"scope");
        Preconditions.checkNotNull((Object)config.getKvtName(), (Object)"kvtName");
        Preconditions.checkArgument((config.getPartitionCount() > 0 ? 1 : 0) != 0, (Object)"Number of partitions should be > 0.");
        Preconditions.checkArgument((config.getPrimaryKeyLength() > 0 ? 1 : 0) != 0, (Object)"Length of primary key should be > 0.");
        Preconditions.checkArgument((config.getSecondaryKeyLength() >= 0 ? 1 : 0) != 0, (Object)"Length of secondary key should be >= 0.");
        return KeyValueTableConfiguration.builder().partitionCount(config.getPartitionCount()).primaryKeyLength(config.getPrimaryKeyLength()).secondaryKeyLength(config.getSecondaryKeyLength()).rolloverSizeBytes(config.getRolloverSizeBytes()).build();
    }

    public static final PravegaNodeUri encode(Controller.NodeUri uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        return new PravegaNodeUri(uri.getEndpoint(), uri.getPort());
    }

    public static final List<Map.Entry<Double, Double>> encode(Map<Double, Double> keyRanges) {
        Preconditions.checkNotNull(keyRanges, (Object)"keyRanges");
        return keyRanges.entrySet().stream().map(x -> new AbstractMap.SimpleEntry<Double, Double>((Double)x.getKey(), (Double)x.getValue())).collect(Collectors.toList());
    }

    public static final Transaction.Status encode(Controller.TxnState.State state, String logString) {
        Transaction.Status result;
        Preconditions.checkNotNull((Object)state, (Object)"state");
        Exceptions.checkNotNullOrEmpty((String)logString, (String)"logString");
        switch (state) {
            case COMMITTED: {
                result = Transaction.Status.COMMITTED;
                break;
            }
            case ABORTED: {
                result = Transaction.Status.ABORTED;
                break;
            }
            case OPEN: {
                result = Transaction.Status.OPEN;
                break;
            }
            case ABORTING: {
                result = Transaction.Status.ABORTING;
                break;
            }
            case COMMITTING: {
                result = Transaction.Status.COMMITTING;
                break;
            }
            case UNKNOWN: {
                throw new StatusRuntimeException(Status.NOT_FOUND);
            }
            default: {
                throw new IllegalStateException("Unknown status: " + state);
            }
        }
        return result;
    }

    public static final Transaction.PingStatus encode(Controller.PingTxnStatus.Status status, String logString) throws PingFailedException {
        Transaction.PingStatus result;
        Preconditions.checkNotNull((Object)status, (Object)"status");
        Exceptions.checkNotNullOrEmpty((String)logString, (String)"logString");
        switch (status) {
            case OK: {
                result = Transaction.PingStatus.OPEN;
                break;
            }
            case COMMITTED: {
                result = Transaction.PingStatus.COMMITTED;
                break;
            }
            case ABORTED: {
                result = Transaction.PingStatus.ABORTED;
                break;
            }
            case UNKNOWN: {
                throw new StatusRuntimeException(Status.NOT_FOUND);
            }
            default: {
                throw new PingFailedException("Ping transaction for " + logString + " failed with status " + status);
            }
        }
        return result;
    }

    public static final SegmentWithRange encode(Controller.SegmentRange segmentRange) {
        return new SegmentWithRange(ModelHelper.encode(segmentRange.getSegmentId()), segmentRange.getMinKey(), segmentRange.getMaxKey());
    }

    public static Map<Long, Long> encode(Controller.StreamCut streamCut) {
        return streamCut.getCutMap();
    }

    public static ReaderGroupConfig encode(Controller.ReaderGroupConfiguration rgConfig) {
        ReaderGroupConfig cfg = ReaderGroupConfig.builder().automaticCheckpointIntervalMillis(rgConfig.getAutomaticCheckpointIntervalMillis()).groupRefreshTimeMillis(rgConfig.getGroupRefreshTimeMillis()).maxOutstandingCheckpointRequest(rgConfig.getMaxOutstandingCheckpointRequest()).retentionType(ReaderGroupConfig.StreamDataRetention.values()[rgConfig.getRetentionType()]).startingStreamCuts(rgConfig.getStartingStreamCutsList().stream().collect(Collectors.toMap(streamCut -> Stream.of(streamCut.getStreamInfo().getScope(), streamCut.getStreamInfo().getStream()), streamCut -> ModelHelper.generateStreamCut(streamCut.getStreamInfo().getScope(), streamCut.getStreamInfo().getStream(), streamCut.getCutMap())))).endingStreamCuts(rgConfig.getEndingStreamCutsList().stream().collect(Collectors.toMap(streamCut -> Stream.of(streamCut.getStreamInfo().getScope(), streamCut.getStreamInfo().getStream()), streamCut -> ModelHelper.generateStreamCut(streamCut.getStreamInfo().getScope(), streamCut.getStreamInfo().getStream(), streamCut.getCutMap())))).build();
        return ReaderGroupConfig.cloneConfig(cfg, UUID.fromString(rgConfig.getReaderGroupId()), rgConfig.getGeneration());
    }

    public static StreamCut generateStreamCut(String scope, String stream, Map<Long, Long> cutMap) {
        if (cutMap.isEmpty()) {
            return StreamCut.UNBOUNDED;
        }
        return new StreamCutImpl(Stream.of(scope, stream), ModelHelper.getSegmentOffsetMap(scope, stream, cutMap));
    }

    public static Map<Segment, Long> getSegmentOffsetMap(String scopeName, String streamName, Map<Long, Long> streamCutMap) {
        return streamCutMap.entrySet().stream().collect(Collectors.toMap(s -> new Segment(scopeName, streamName, (Long)s.getKey()), s -> (Long)s.getValue()));
    }

    public static final Controller.TxnId decode(UUID txnId) {
        Preconditions.checkNotNull((Object)txnId, (Object)"txnId");
        return Controller.TxnId.newBuilder().setHighBits(txnId.getMostSignificantBits()).setLowBits(txnId.getLeastSignificantBits()).build();
    }

    public static final Controller.SegmentId decode(Segment segment) {
        Preconditions.checkNotNull((Object)segment, (Object)"segment");
        return ModelHelper.createSegmentId(segment.getScope(), segment.getStreamName(), segment.getSegmentId());
    }

    public static final Controller.ScalingPolicy decode(ScalingPolicy policyModel) {
        Preconditions.checkNotNull((Object)policyModel, (Object)"policyModel");
        return Controller.ScalingPolicy.newBuilder().setScaleType(Controller.ScalingPolicy.ScalingPolicyType.valueOf((String)policyModel.getScaleType().name())).setTargetRate(policyModel.getTargetRate()).setScaleFactor(policyModel.getScaleFactor()).setMinNumSegments(policyModel.getMinNumSegments()).build();
    }

    public static final Controller.RetentionPolicy decode(RetentionPolicy policyModel) {
        if (policyModel != null) {
            Controller.RetentionPolicy.Builder builder = Controller.RetentionPolicy.newBuilder().setRetentionType(Controller.RetentionPolicy.RetentionPolicyType.valueOf((String)policyModel.getRetentionType().name())).setRetentionParam(policyModel.getRetentionParam()).setRetentionMax(policyModel.getRetentionMax());
            return builder.build();
        }
        return null;
    }

    public static final Controller.StreamConfig decode(String scope, String streamName, StreamConfiguration configModel) {
        Preconditions.checkNotNull((Object)configModel, (Object)"configModel");
        Controller.StreamConfig.Builder builder = Controller.StreamConfig.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(scope, streamName)).setScalingPolicy(ModelHelper.decode(configModel.getScalingPolicy()));
        if (configModel.getRetentionPolicy() != null) {
            builder.setRetentionPolicy(ModelHelper.decode(configModel.getRetentionPolicy()));
        }
        builder.setTags(Controller.Tags.newBuilder().addAllTag(configModel.getTags()).build());
        builder.setTimestampAggregationTimeout(configModel.getTimestampAggregationTimeout());
        builder.setRolloverSizeBytes(configModel.getRolloverSizeBytes());
        return builder.build();
    }

    public static final Controller.StreamSubscriberInfo decode(String scope, String streamName, String subscriber, long generation) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope");
        Preconditions.checkNotNull((Object)streamName, (Object)"streamName");
        Preconditions.checkNotNull((Object)subscriber, (Object)"subscriber");
        Controller.StreamSubscriberInfo.Builder builder = Controller.StreamSubscriberInfo.newBuilder().setScope(scope).setStream(streamName).setSubscriber(subscriber).setOperationGeneration(generation);
        return builder.build();
    }

    public static final Controller.SubscriberStreamCut decode(String scope, String streamName, String subscriber, UUID readerGroupId, long generation, Map<Long, Long> streamCut) {
        Preconditions.checkNotNull((Object)scope, (Object)"scope");
        Preconditions.checkNotNull((Object)streamName, (Object)"streamName");
        Preconditions.checkNotNull((Object)subscriber, (Object)"subscriber");
        Preconditions.checkNotNull(streamCut, (Object)"streamCut");
        Preconditions.checkNotNull((Object)readerGroupId, (Object)"readerGroupId");
        Controller.SubscriberStreamCut.Builder builder = Controller.SubscriberStreamCut.newBuilder().setSubscriber(subscriber).setGeneration(generation).setReaderGroupId(readerGroupId.toString()).setStreamCut(ModelHelper.decode(scope, streamName, streamCut));
        return builder.build();
    }

    public static final Controller.KeyValueTableConfig decode(String scopeName, String kvtName, KeyValueTableConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"config");
        Preconditions.checkNotNull((Object)scopeName, (Object)"scopeName");
        Preconditions.checkNotNull((Object)kvtName, (Object)"kvtName");
        Preconditions.checkArgument((config.getPartitionCount() > 0 ? 1 : 0) != 0, (Object)"Number of partitions should be > 0.");
        Preconditions.checkArgument((config.getPrimaryKeyLength() > 0 ? 1 : 0) != 0, (Object)"Length of primary key should be > 0.");
        Preconditions.checkArgument((config.getSecondaryKeyLength() >= 0 ? 1 : 0) != 0, (Object)"Length of secondary key should be >= 0.");
        Preconditions.checkArgument((config.getRolloverSizeBytes() >= 0L ? 1 : 0) != 0, (Object)"Rollover size should be >= 0.");
        return Controller.KeyValueTableConfig.newBuilder().setScope(scopeName).setKvtName(kvtName).setPartitionCount(config.getPartitionCount()).setPrimaryKeyLength(config.getPrimaryKeyLength()).setSecondaryKeyLength(config.getSecondaryKeyLength()).setRolloverSizeBytes(config.getRolloverSizeBytes()).build();
    }

    public static final Controller.NodeUri decode(PravegaNodeUri uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        return Controller.NodeUri.newBuilder().setEndpoint(uri.getEndpoint()).setPort(uri.getPort()).build();
    }

    public static Controller.StreamCut decode(String scope, String stream, Map<Long, Long> streamCut) {
        return Controller.StreamCut.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(scope, stream)).putAllCut(streamCut).build();
    }

    public static Controller.StreamCutRange decode(String scope, String stream, Map<Long, Long> from, Map<Long, Long> to) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return Controller.StreamCutRange.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(scope, stream)).putAllFrom(from).putAllTo(to).build();
    }

    public static final Controller.ReaderGroupConfiguration decode(String scope, String groupName, ReaderGroupConfig config) {
        return ModelHelper.decode(scope, groupName, config, config.getReaderGroupId());
    }

    public static final Controller.ReaderGroupConfiguration decode(String scope, String groupName, ReaderGroupConfig config, UUID readerGroupId) {
        Preconditions.checkNotNull((Object)scope, (Object)"ReaderGroup scope is null");
        Preconditions.checkNotNull((Object)groupName, (Object)"ReaderGroup name is null");
        Preconditions.checkNotNull((Object)config, (Object)"ReaderGroupConfig is null");
        List startStreamCuts = config.getStartingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(((Stream)e.getKey()).getScope(), ((Stream)e.getKey()).getStreamName())).putAllCut(ModelHelper.getStreamCutMap((StreamCut)e.getValue())).build()).collect(Collectors.toList());
        List endStreamCuts = config.getEndingStreamCuts().entrySet().stream().map(e -> Controller.StreamCut.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(((Stream)e.getKey()).getScope(), ((Stream)e.getKey()).getStreamName())).putAllCut(ModelHelper.getStreamCutMap((StreamCut)e.getValue())).build()).collect(Collectors.toList());
        Controller.ReaderGroupConfiguration.Builder builder = Controller.ReaderGroupConfiguration.newBuilder().setScope(scope).setReaderGroupName(groupName).setGroupRefreshTimeMillis(config.getGroupRefreshTimeMillis()).setAutomaticCheckpointIntervalMillis(config.getAutomaticCheckpointIntervalMillis()).setMaxOutstandingCheckpointRequest(config.getMaxOutstandingCheckpointRequest()).setRetentionType(config.getRetentionType().ordinal()).setGeneration(config.getGeneration()).setReaderGroupId(readerGroupId.toString()).addAllStartingStreamCuts(startStreamCuts).addAllEndingStreamCuts(endStreamCuts);
        return builder.build();
    }

    public static ImmutableMap<Long, Long> getStreamCutMap(StreamCut streamCut) {
        if (streamCut.equals(StreamCut.UNBOUNDED)) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        streamCut.asImpl().getPositions().entrySet().stream().forEach(entry -> mapBuilder.put((Object)((Segment)entry.getKey()).getSegmentId(), (Object)((Long)entry.getValue())));
        return mapBuilder.build();
    }

    public static final Controller.ScopeInfo createScopeInfo(String scope) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        return Controller.ScopeInfo.newBuilder().setScope(scope).build();
    }

    public static final Controller.StreamInfo createStreamInfo(String scope, String stream, AccessOperation accessOperation) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Controller.StreamInfo.Builder builder = Controller.StreamInfo.newBuilder().setScope(scope).setStream(stream);
        if (accessOperation != null) {
            builder.setAccessOperation(Controller.StreamInfo.AccessOperation.valueOf((String)accessOperation.name()));
        }
        return builder.build();
    }

    public static final Controller.StreamInfo createStreamInfo(String scope, String stream) {
        return ModelHelper.createStreamInfo(scope, stream, null);
    }

    public static final Controller.ReaderGroupInfo createReaderGroupInfo(String scope, String readerGroup, String readerGroupId, long generation) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)readerGroup, (String)"readerGroup");
        Preconditions.checkNotNull((Object)readerGroupId, (Object)"readerGroupId");
        Controller.ReaderGroupInfo.Builder builder = Controller.ReaderGroupInfo.newBuilder().setScope(scope).setReaderGroup(readerGroup).setReaderGroupId(readerGroupId).setGeneration(generation);
        return builder.build();
    }

    public static final Controller.KeyValueTableInfo createKeyValueTableInfo(String scope, String kvtName) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)kvtName, (String)"KeyValueTable");
        return Controller.KeyValueTableInfo.newBuilder().setScope(scope).setKvtName(kvtName).build();
    }

    public static final Controller.SegmentId createSegmentId(String scope, String stream, long segmentId) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return Controller.SegmentId.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(scope, stream)).setSegmentId(segmentId).build();
    }

    public static final Controller.SegmentRange createSegmentRange(String scope, String stream, long segmentId, double rangeMinKey, double rangeMaxKey) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        return Controller.SegmentRange.newBuilder().setSegmentId(ModelHelper.createSegmentId(scope, stream, segmentId)).setMinKey(rangeMinKey).setMaxKey(rangeMaxKey).build();
    }

    public static final Controller.StreamCutRangeResponse createStreamCutRangeResponse(String scope, String stream, List<Controller.SegmentId> segments, String delegationToken) {
        Exceptions.checkNotNullOrEmpty((String)scope, (String)"scope");
        Exceptions.checkNotNullOrEmpty((String)stream, (String)"stream");
        Exceptions.checkArgument((boolean)segments.stream().allMatch(x -> x.getStreamInfo().getScope().equals(scope) && x.getStreamInfo().getStream().equals(stream)), (String)"streamInfo", (String)"stream info does not match segment id", (Object[])new Object[]{scope, stream, segments});
        return Controller.StreamCutRangeResponse.newBuilder().addAllSegments(segments).setDelegationToken(delegationToken).build();
    }

    public static Controller.StreamCut createStreamCut(Stream stream, WriterPosition position) {
        Controller.StreamCut.Builder builder = Controller.StreamCut.newBuilder().setStreamInfo(ModelHelper.createStreamInfo(stream.getScope(), stream.getStreamName()));
        for (Map.Entry<Segment, Long> entry : position.getSegmentsWithOffsets().entrySet()) {
            builder.putCut(entry.getKey().getSegmentId(), entry.getValue().longValue());
        }
        return builder.build();
    }

    public static final Controller.SuccessorResponse.Builder createSuccessorResponse(Map<Controller.SegmentRange, List<Long>> segments) {
        Preconditions.checkNotNull(segments);
        return Controller.SuccessorResponse.newBuilder().addAllSegments((Iterable)segments.entrySet().stream().map(segmentRangeListEntry -> Controller.SuccessorResponse.SegmentEntry.newBuilder().setSegment((Controller.SegmentRange)segmentRangeListEntry.getKey()).addAllValue((Iterable)segmentRangeListEntry.getValue()).build()).collect(Collectors.toList()));
    }
}

