/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.stream.impl;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.stream.impl.SegmentWithRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class StreamSegmentsWithPredecessors {
    private final Map<SegmentWithRange, List<Long>> segmentWithPredecessors;
    private final Map<Long, List<SegmentWithRange>> replacementRanges;
    private final String delegationToken;

    public StreamSegmentsWithPredecessors(Map<SegmentWithRange, List<Long>> segments, String delegationToken) {
        this.segmentWithPredecessors = ImmutableMap.copyOf(segments);
        HashMap<Long, ArrayList<SegmentWithRange>> replacementRanges = new HashMap<Long, ArrayList<SegmentWithRange>>();
        for (Map.Entry<SegmentWithRange, List<Long>> entry : segments.entrySet()) {
            for (Long oldSegment : entry.getValue()) {
                ArrayList<SegmentWithRange> newRanges = (ArrayList<SegmentWithRange>)replacementRanges.get(oldSegment);
                if (newRanges == null) {
                    newRanges = new ArrayList<SegmentWithRange>(2);
                    replacementRanges.put(oldSegment, newRanges);
                }
                newRanges.add(entry.getKey());
            }
        }
        this.replacementRanges = Collections.unmodifiableMap(replacementRanges);
        this.delegationToken = delegationToken;
    }

    public Map<SegmentWithRange, List<Long>> getSegmentToPredecessor() {
        return this.segmentWithPredecessors;
    }

    public Map<Long, List<SegmentWithRange>> getReplacementRanges() {
        return this.replacementRanges;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StreamSegmentsWithPredecessors)) {
            return false;
        }
        StreamSegmentsWithPredecessors other = (StreamSegmentsWithPredecessors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<SegmentWithRange, List<Long>> this$segmentWithPredecessors = this.segmentWithPredecessors;
        Map<SegmentWithRange, List<Long>> other$segmentWithPredecessors = other.segmentWithPredecessors;
        if (this$segmentWithPredecessors == null ? other$segmentWithPredecessors != null : !((Object)this$segmentWithPredecessors).equals(other$segmentWithPredecessors)) {
            return false;
        }
        Map<Long, List<SegmentWithRange>> this$replacementRanges = this.getReplacementRanges();
        Map<Long, List<SegmentWithRange>> other$replacementRanges = other.getReplacementRanges();
        if (this$replacementRanges == null ? other$replacementRanges != null : !((Object)this$replacementRanges).equals(other$replacementRanges)) {
            return false;
        }
        String this$delegationToken = this.getDelegationToken();
        String other$delegationToken = other.getDelegationToken();
        return !(this$delegationToken == null ? other$delegationToken != null : !this$delegationToken.equals(other$delegationToken));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StreamSegmentsWithPredecessors;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<SegmentWithRange, List<Long>> $segmentWithPredecessors = this.segmentWithPredecessors;
        result = result * 59 + ($segmentWithPredecessors == null ? 43 : ((Object)$segmentWithPredecessors).hashCode());
        Map<Long, List<SegmentWithRange>> $replacementRanges = this.getReplacementRanges();
        result = result * 59 + ($replacementRanges == null ? 43 : ((Object)$replacementRanges).hashCode());
        String $delegationToken = this.getDelegationToken();
        result = result * 59 + ($delegationToken == null ? 43 : $delegationToken.hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StreamSegmentsWithPredecessors(segmentWithPredecessors=" + this.segmentWithPredecessors + ", replacementRanges=" + this.getReplacementRanges() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDelegationToken() {
        return this.delegationToken;
    }
}

