/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.tables.impl;

import io.netty.buffer.ByteBuf;
import io.pravega.client.tables.IteratorItem;
import io.pravega.client.tables.impl.SegmentIteratorArgs;
import io.pravega.common.ObjectClosedException;
import io.pravega.common.concurrent.Futures;
import io.pravega.common.util.AsyncIterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import lombok.NonNull;

class TableSegmentIterator<T>
implements AsyncIterator<IteratorItem<T>> {
    private final Function<SegmentIteratorArgs, CompletableFuture<IteratorItem<T>>> fetchNext;
    private final Function<T, ByteBuf> getKey;
    private final AtomicReference<SegmentIteratorArgs> args;

    TableSegmentIterator(@NonNull Function<SegmentIteratorArgs, CompletableFuture<IteratorItem<T>>> fetchNext, @NonNull Function<T, ByteBuf> getKey, @NonNull SegmentIteratorArgs args) {
        if (fetchNext == null) {
            throw new NullPointerException("fetchNext is marked non-null but is null");
        }
        if (getKey == null) {
            throw new NullPointerException("getKey is marked non-null but is null");
        }
        if (args == null) {
            throw new NullPointerException("args is marked non-null but is null");
        }
        this.fetchNext = fetchNext;
        this.getKey = getKey;
        this.args = new AtomicReference<SegmentIteratorArgs>(args);
    }

    public CompletableFuture<IteratorItem<T>> getNext() {
        if (this.args.get() == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletionStage result = this.fetchNext.apply(this.args.get()).thenApply(r -> {
            if (r == null) {
                this.args.set(null);
                return null;
            }
            ByteBuf lastKey = r.getItems().isEmpty() ? null : this.getKey.apply(r.getItems().get(r.getItems().size() - 1));
            this.args.set(this.args.get().next(lastKey));
            return r;
        });
        Futures.exceptionListener((CompletableFuture)result, ObjectClosedException.class, ex -> this.args.set(null));
        return result;
    }
}

