/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.navercorp.pinpoint.profiler.cache.Cache;
import com.navercorp.pinpoint.profiler.cache.CaffeineBuilder;
import com.navercorp.pinpoint.profiler.cache.IdAllocator;
import com.navercorp.pinpoint.profiler.cache.Result;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

public class SimpleCache<T>
implements Cache<T, Result<Integer>> {
    private final ConcurrentMap<T, Result<Integer>> cache;
    private final IdAllocator idAllocator;

    public SimpleCache(IdAllocator idAllocator) {
        this(idAllocator, 1024);
    }

    public SimpleCache(IdAllocator idAllocator, int cacheSize) {
        this.cache = this.createCache(cacheSize);
        this.idAllocator = Objects.requireNonNull(idAllocator, "idTransformer");
    }

    private ConcurrentMap<T, Result<Integer>> createCache(int maxCacheSize) {
        Caffeine<Object, Object> cacheBuilder = CaffeineBuilder.newBuilder();
        cacheBuilder.initialCapacity(maxCacheSize);
        cacheBuilder.maximumSize((long)maxCacheSize);
        com.github.benmanes.caffeine.cache.Cache localCache = cacheBuilder.build();
        return localCache.asMap();
    }

    @Override
    public Result<Integer> put(T value) {
        Result find = (Result)this.cache.get(value);
        if (find != null) {
            return find;
        }
        int newId = this.nextId();
        Result<Integer> result = new Result<Integer>(false, newId);
        Result<Integer> before = this.cache.putIfAbsent(value, result);
        if (before != null) {
            return before;
        }
        return new Result<Integer>(true, newId);
    }

    private int nextId() {
        return this.idAllocator.allocate();
    }
}

